/*
 * Copyright 2015-2018 52°North Initiative for Geospatial Open Source
 * Software GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.n52.iceland.ogc.ows;

/**
 * Setting definitions for the OWS Service Identification.
 *
 * @author <a href="mailto:c.autermann@52north.org">Christian Autermann</a>
 *
 * @since 1.0.0
 */
public interface OwsServiceIdentificationFactorySettings {
    @Deprecated
    String SERVICE_TYPE = "serviceIdentification.serviceType";

    @Deprecated
    String SERVICE_TYPE_CODE_SPACE
            = "serviceIdentification.serviceTypeCodeSpace";

    String ACCESS_CONSTRAINTS = "serviceIdentification.accessConstraints";

    @Deprecated
    String FILE = "serviceIdentification.file";

    String TITLE = "serviceIdentification.title";

    String KEYWORDS = "serviceIdentification.keywords";

    String ABSTRACT = "serviceIdentification.abstract";

    String FEES = "serviceIdentification.fees";

}
