/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.service.operator;

import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.n52.iceland.service.operator.ServiceOperator;
import org.n52.iceland.service.operator.ServiceOperatorFactory;
import org.n52.janmayen.Producer;
import org.n52.janmayen.component.AbstractComponentRepository;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.shetland.ogc.ows.service.OwsServiceKey;

public class ServiceOperatorRepository
extends AbstractComponentRepository<OwsServiceKey, ServiceOperator, ServiceOperatorFactory>
implements Constructable {
    @Deprecated
    private static ServiceOperatorRepository instance;
    private final Map<OwsServiceKey, Producer<ServiceOperator>> serviceOperators = Maps.newHashMap();
    private final Map<String, Set<String>> supportedVersions = Maps.newHashMap();
    @Inject
    private Optional<Collection<ServiceOperator>> components = Optional.of(Collections.emptyList());
    @Inject
    private Optional<Collection<ServiceOperatorFactory>> componentFactories = Optional.of(Collections.emptyList());

    public void init() {
        this.setStaticInstance();
        Map implementations = this.getUniqueProviders(this.components, this.componentFactories);
        this.serviceOperators.clear();
        this.supportedVersions.clear();
        this.serviceOperators.putAll(implementations);
        this.supportedVersions.putAll(implementations.keySet().stream().collect(Collectors.groupingBy(OwsServiceKey::getService, Collectors.mapping(OwsServiceKey::getVersion, Collectors.toSet()))));
    }

    public Map<OwsServiceKey, ServiceOperator> getServiceOperators() {
        return this.serviceOperators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ServiceOperator)((Producer)e.getValue()).get()));
    }

    @Deprecated
    public Set<OwsServiceKey> getServiceOperatorKeyTypes() {
        return this.getServiceOperatorKeys();
    }

    public Set<OwsServiceKey> getServiceOperatorKeys() {
        return this.getServiceOperators().keySet();
    }

    public ServiceOperator getServiceOperator(OwsServiceKey sok) {
        Producer<ServiceOperator> producer = this.serviceOperators.get(sok);
        return producer == null ? null : (ServiceOperator)producer.get();
    }

    public ServiceOperator getServiceOperator(String service, String version) {
        return this.getServiceOperator(new OwsServiceKey(service, version));
    }

    public Set<String> getAllSupportedVersions() {
        return this.supportedVersions.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<String> getSupportedVersions(String service) {
        return Collections.unmodifiableSet(this.supportedVersions.getOrDefault(service, Collections.emptySet()));
    }

    public boolean isVersionSupported(String service, String version) {
        return this.getSupportedVersions(service).contains(version);
    }

    public Set<String> getSupportedServices() {
        return Collections.unmodifiableSet(this.supportedVersions.keySet());
    }

    public boolean isServiceSupported(String service) {
        return this.supportedVersions.containsKey(service);
    }

    @Deprecated
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private void setStaticInstance() {
        instance = this;
    }

    @Deprecated
    public static ServiceOperatorRepository getInstance() {
        return instance;
    }
}

