/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.ogc.ows;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.n52.faroe.SettingsService;
import org.n52.iceland.ogc.ows.OwsServiceIdentificationFactory;
import org.n52.iceland.ogc.ows.OwsServiceMetadataRepository;
import org.n52.iceland.ogc.ows.OwsServiceProviderFactory;
import org.n52.iceland.service.operator.ServiceOperatorRepository;
import org.n52.iceland.util.LocalizedProducer;
import org.n52.shetland.ogc.ows.OwsServiceIdentification;
import org.n52.shetland.ogc.ows.OwsServiceProvider;

public class OwsServiceMetadataRepositoryImpl
implements OwsServiceMetadataRepository {
    private final Map<String, LocalizedProducer<OwsServiceProvider>> serviceProviders = Collections.synchronizedMap(new HashMap());
    private final Map<String, LocalizedProducer<OwsServiceIdentification>> serviceIdentifications = Collections.synchronizedMap(new HashMap());
    private SettingsService settingsService;
    private ServiceOperatorRepository serviceOperatorRepository;

    @Inject
    public void setServiceOperatorRepository(ServiceOperatorRepository serviceOperatorRepository) {
        this.serviceOperatorRepository = serviceOperatorRepository;
    }

    @Inject
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public LocalizedProducer<OwsServiceIdentification> getServiceIdentificationFactory(String service) {
        return this.serviceIdentifications.computeIfAbsent(service, this::createServiceIdentificationFactory);
    }

    @Override
    public LocalizedProducer<OwsServiceProvider> getServiceProviderFactory(String service) {
        return this.serviceProviders.computeIfAbsent(service, this::createServiceProviderFactory);
    }

    private LocalizedProducer<OwsServiceProvider> createServiceProviderFactory(String service) {
        OwsServiceProviderFactory factory = new OwsServiceProviderFactory();
        this.settingsService.configure((Object)factory);
        return factory;
    }

    private LocalizedProducer<OwsServiceIdentification> createServiceIdentificationFactory(String service) {
        OwsServiceIdentificationFactory factory = new OwsServiceIdentificationFactory(service, this.serviceOperatorRepository);
        this.settingsService.configure((Object)factory);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Locale> getAvailableLocales() {
        Set forIdentifications;
        Set forProviders;
        Map<String, LocalizedProducer<OwsServiceProvider>> map = this.serviceProviders;
        synchronized (map) {
            forProviders = this.serviceProviders.values().stream().map(LocalizedProducer::getAvailableLocales).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        map = this.serviceIdentifications;
        synchronized (map) {
            forIdentifications = this.serviceIdentifications.values().stream().map(LocalizedProducer::getAvailableLocales).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return Stream.of(forProviders, forIdentifications).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

