/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.convert;

import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.n52.iceland.convert.Converter;
import org.n52.iceland.convert.ConverterFactory;
import org.n52.iceland.convert.ConverterKey;
import org.n52.janmayen.Producer;
import org.n52.janmayen.component.AbstractComponentRepository;
import org.n52.janmayen.lifecycle.Constructable;

public class ConverterRepository
extends AbstractComponentRepository<ConverterKey, Converter<?, ?>, ConverterFactory>
implements Constructable {
    @Deprecated
    private static ConverterRepository instance;
    private Optional<Collection<Converter<?, ?>>> components = Optional.of(Collections.emptyList());
    private Optional<Collection<ConverterFactory>> componentFactories = Optional.of(Collections.emptyList());
    private final Map<ConverterKey, Producer<Converter<?, ?>>> converter = new HashMap(0);

    @Inject
    public void setComponentFactories(Optional<Collection<ConverterFactory>> componentFactories) {
        this.componentFactories = componentFactories;
    }

    @Inject
    public void setComponents(Optional<Collection<Converter<?, ?>>> components) {
        this.components = components;
    }

    public void init() {
        this.setStaticInstance();
        Map implementations = this.getUniqueProviders(this.components, this.componentFactories);
        this.converter.clear();
        this.converter.putAll(implementations);
    }

    public <T, F> Converter<T, F> getConverter(String fromNamespace, String toNamespace) {
        return this.getConverter(new ConverterKey(fromNamespace, toNamespace));
    }

    public <T, F> Converter<T, F> getConverter(ConverterKey key) {
        Supplier producer = (Supplier)this.converter.get(key);
        if (producer == null) {
            return null;
        }
        return (Converter)producer.get();
    }

    public Set<String> getFromNamespaceConverterTo(String toNamespace) {
        HashSet fromNamespaces = Sets.newHashSet();
        for (ConverterKey converterKey : this.converter.keySet()) {
            if (!toNamespace.equals(converterKey.getToNamespace())) continue;
            fromNamespaces.add(converterKey.getFromNamespace());
        }
        return fromNamespaces;
    }

    public Set<String> getToNamespaceConverterFrom(String fromNamespace) {
        HashSet toNamespaces = Sets.newHashSet();
        for (ConverterKey converterKey : this.converter.keySet()) {
            if (!fromNamespace.equals(converterKey.getFromNamespace())) continue;
            toNamespaces.add(converterKey.getToNamespace());
        }
        return toNamespaces;
    }

    public boolean hasConverter(String fromNamespace, String toNamespace) {
        return this.hasConverter(new ConverterKey(fromNamespace, toNamespace));
    }

    public boolean hasConverter(ConverterKey key) {
        return this.converter.containsKey(key);
    }

    @Deprecated
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private void setStaticInstance() {
        instance = this;
    }

    @Deprecated
    public static ConverterRepository getInstance() {
        return instance;
    }
}

