/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.cache.ctrl;

import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.n52.iceland.cache.ContentCachePersistenceStrategy;
import org.n52.iceland.cache.ContentCacheUpdate;
import org.n52.iceland.cache.WritableContentCache;
import org.n52.iceland.cache.ctrl.AbstractSchedulingContentCacheController;
import org.n52.iceland.cache.ctrl.CompleteCacheUpdateFactory;
import org.n52.iceland.cache.ctrl.ContentCacheFactory;
import org.n52.janmayen.lifecycle.Constructable;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentCacheControllerImpl
extends AbstractSchedulingContentCacheController
implements Constructable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentCacheControllerImpl.class);
    private static final AtomicInteger COMPLETE_UPDATE_COUNT = new AtomicInteger(0);
    private static final AtomicInteger PARTIAL_UPDATE_COUNT = new AtomicInteger(0);
    private volatile WritableContentCache cache;
    private final ReentrantLock lock = new ReentrantLock();
    private CompleteUpdate current;
    private CompleteUpdate next;
    private ContentCachePersistenceStrategy persistenceStrategy;
    private ContentCacheFactory cacheFactory;
    private CompleteCacheUpdateFactory completeCacheUpdateFactory;

    @Inject
    public void setCacheFactory(ContentCacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    @Inject
    public void setPersistenceStrategy(ContentCachePersistenceStrategy persistenceStrategy) {
        this.persistenceStrategy = persistenceStrategy;
    }

    @Inject
    public void setCompleteCacheUpdateFactory(CompleteCacheUpdateFactory factory) {
        this.completeCacheUpdateFactory = factory;
    }

    public void init() {
        this.loadOrCreateCache();
    }

    private void loadOrCreateCache() {
        Optional<WritableContentCache> optionalCache = this.persistenceStrategy.load();
        if (optionalCache.isPresent()) {
            this.setCache(optionalCache.get());
        } else {
            this.setCache((WritableContentCache)this.cacheFactory.get());
            try {
                this.update();
            }
            catch (OwsExceptionReport e) {
                LOGGER.warn("Couldn't load cache from datasource, maybe the datasource isn't configured yet?", (Throwable)e);
            }
        }
        this.setInitialized(true);
    }

    @Override
    public WritableContentCache getCache() {
        return this.cache;
    }

    protected void setCache(WritableContentCache wcc) {
        this.cache = wcc;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.lock();
        try {
            this.persistenceStrategy.persistOnShutdown(this.getCache());
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void update() throws OwsExceptionReport {
        this.update((ContentCacheUpdate)this.completeCacheUpdateFactory.get());
    }

    @Override
    public void update(ContentCacheUpdate update) throws OwsExceptionReport {
        if (update != null) {
            if (update.isCompleteUpdate()) {
                this.executeComplete(new CompleteUpdate(update));
            } else {
                this.executePartial(new PartialUpdate(update));
            }
        } else {
            throw new IllegalArgumentException("update may not be null");
        }
        this.cache.setLastUpdateTime(DateTime.now());
    }

    private void runCurrent() throws OwsExceptionReport {
        LOGGER.trace("Starting update {}", (Object)this.current);
        this.current.execute();
        LOGGER.trace("Finished update {}", (Object)this.current);
        this.lock();
        try {
            this.persistenceStrategy.persistOnCompleteUpdate(this.getCache());
            CompleteUpdate u = this.current;
            this.current = null;
            u.signalWaiting();
        }
        finally {
            this.unlock();
        }
    }

    private void executePartial(PartialUpdate update) throws OwsExceptionReport {
        update.execute(this.getCache());
        this.lock();
        try {
            if (this.current != null) {
                this.current.addUpdate(update);
            } else {
                this.persistenceStrategy.persistOnPartialUpdate(this.getCache());
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeComplete(CompleteUpdate update) throws OwsExceptionReport {
        boolean isCurrent = false;
        boolean isNext = false;
        CompleteUpdate waitFor = null;
        this.lock();
        try {
            if (this.current == null || this.current.isFinished()) {
                this.current = update;
                isCurrent = true;
            } else if (this.current.isNotYetStarted()) {
                waitFor = this.current;
            } else if (this.next == null || this.next.isFinished()) {
                this.next = update;
                waitFor = this.current;
                isNext = true;
            } else {
                waitFor = this.next;
            }
        }
        finally {
            this.unlock();
        }
        if (isCurrent) {
            this.runCurrent();
        } else if (isNext) {
            this.waitFor(waitFor, update);
            this.lock();
            try {
                this.current = this.next;
                this.next = null;
            }
            finally {
                this.unlock();
            }
            this.runCurrent();
        } else {
            this.waitFor(waitFor, update);
        }
    }

    private void waitFor(CompleteUpdate running, CompleteUpdate update) throws OwsExceptionReport {
        if (running != null) {
            LOGGER.trace("{} waiting for {}", (Object)update, (Object)running);
            running.waitForCompletion();
            LOGGER.trace("{} stopped waiting for {}", (Object)update, (Object)running);
        }
    }

    private void lock() {
        this.lock.lock();
    }

    private void unlock() {
        this.lock.unlock();
    }

    @Override
    public boolean isUpdateInProgress() {
        return this.current != null;
    }

    @Override
    public ContentCachePersistenceStrategy getContentCachePersistenceStrategy() {
        return this.persistenceStrategy;
    }

    private class CompleteUpdate
    extends Update {
        private final ConcurrentLinkedQueue<PartialUpdate> updates;
        private final Lock lock;
        private final Condition finished;
        private State state;
        private final int nr;

        CompleteUpdate(ContentCacheUpdate update) {
            super(update);
            this.updates = new ConcurrentLinkedQueue();
            this.lock = new ReentrantLock();
            this.finished = this.lock.newCondition();
            this.state = State.WAITING;
            this.nr = COMPLETE_UPDATE_COUNT.getAndIncrement();
        }

        void addUpdate(PartialUpdate update) {
            this.updates.offer(update);
        }

        State getState() {
            this.lock();
            try {
                State state = this.state;
                return state;
            }
            finally {
                this.unlock();
            }
        }

        void setState(State state) {
            ContentCacheControllerImpl.this.lock();
            try {
                this.lock();
                try {
                    LOGGER.debug("State change: {} -> {}", (Object)this.state, (Object)state);
                    this.state = state;
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                ContentCacheControllerImpl.this.unlock();
            }
        }

        boolean isFinished() {
            this.lock();
            try {
                boolean bl = this.getState() == State.FINISHED || this.getState() == State.FAILED;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        boolean isNotYetStarted() {
            this.lock();
            try {
                boolean bl = this.getState() == State.WAITING;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        void execute() throws OwsExceptionReport {
            ContentCacheControllerImpl.this.setCache(this.execute(ContentCacheControllerImpl.this.getCache()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WritableContentCache execute(WritableContentCache newCache) throws OwsExceptionReport {
            if (this.isFinished()) {
                throw new IllegalStateException("already finished");
            }
            this.setState(State.RUNNING);
            this.getUpdate().setCache(newCache);
            LOGGER.trace("Starting complete update {}", (Object)this.getUpdate());
            this.getUpdate().execute();
            LOGGER.trace("Finished complete update {}", (Object)this.getUpdate());
            this.lock();
            try {
                PartialUpdate pu;
                if (this.getUpdate().failed()) {
                    this.setState(State.FAILED);
                    LOGGER.warn("Complete update failed!", (Throwable)this.getUpdate().getFailureCause());
                    throw this.getUpdate().getFailureCause();
                }
                this.setState(State.APPLYING_UPDATES);
                WritableContentCache cc = this.getUpdate().getCache();
                while ((pu = this.updates.poll()) != null) {
                    pu.execute(cc);
                }
                this.setState(State.FINISHED);
                WritableContentCache writableContentCache = cc;
                return writableContentCache;
            }
            finally {
                this.unlock();
            }
        }

        void waitForCompletion() throws OwsExceptionReport {
            this.lock();
            try {
                while (!this.isFinished()) {
                    try {
                        this.finished.await();
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Interrupted while waiting for cache update completion", (Throwable)ex);
                    }
                }
                if (this.getState() == State.FAILED) {
                    throw this.getUpdate().getFailureCause();
                }
            }
            finally {
                this.unlock();
            }
        }

        void signalWaiting() {
            this.lock();
            try {
                this.finished.signalAll();
            }
            finally {
                this.unlock();
            }
        }

        public String toString() {
            return String.format("CompleteUpdate[#%d]", this.nr);
        }

        protected void unlock() {
            this.lock.unlock();
        }

        protected void lock() {
            this.lock.lock();
        }
    }

    private class PartialUpdate
    extends Update {
        private final int nr;

        PartialUpdate(ContentCacheUpdate update) {
            super(update);
            this.nr = PARTIAL_UPDATE_COUNT.getAndIncrement();
        }

        synchronized void execute(WritableContentCache newCache) throws OwsExceptionReport {
            LOGGER.trace("Starting partial update {}", (Object)this.getUpdate());
            this.getUpdate().reset();
            this.getUpdate().setCache(newCache);
            this.getUpdate().execute();
            LOGGER.trace("Finished partial update {}", (Object)this.getUpdate());
            if (this.getUpdate().failed()) {
                LOGGER.warn("Partial update failed!", (Throwable)this.getUpdate().getFailureCause());
                throw this.getUpdate().getFailureCause();
            }
        }

        public String toString() {
            return String.format("PartialUpdate[#%d]", this.nr);
        }
    }

    private abstract class Update {
        private final ContentCacheUpdate update;

        Update(ContentCacheUpdate update) {
            this.update = update;
        }

        ContentCacheUpdate getUpdate() {
            return this.update;
        }
    }

    private static enum State {
        WAITING,
        RUNNING,
        APPLYING_UPDATES,
        FINISHED,
        FAILED;

    }
}

