/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.cache.ctrl;

import java.util.Timer;
import java.util.TimerTask;
import org.joda.time.DateTime;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.Validation;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.cache.ContentCacheController;
import org.n52.janmayen.lifecycle.Destroyable;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public abstract class AbstractSchedulingContentCacheController
implements ContentCacheController,
Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchedulingContentCacheController.class);
    private boolean initialized;
    private long updateInterval;
    private final Timer timer = new Timer("52n-iceland-capabilities-cache-controller", true);
    private TimerTask current;

    private void schedule() {
        this.current = new UpdateTimerTask();
        long delay = this.getUpdateInterval();
        if (!this.isInitialized()) {
            delay = 1L;
            this.setInitialized(true);
        }
        if (delay > 0L) {
            LOGGER.info("Next CapabilitiesCacheUpdate in {}m: {}", (Object)(delay / 60000L), (Object)new DateTime(System.currentTimeMillis() + delay));
            this.timer.schedule(this.current, delay);
        }
    }

    @Setting(value="service.capabilitiesCacheUpdateInterval")
    public void setUpdateInterval(int interval) throws ConfigurationError {
        Validation.greaterEqualZero((String)"Cache update interval", (int)interval);
        if (this.updateInterval != (long)interval) {
            this.updateInterval = interval;
            this.reschedule();
        }
    }

    private long getUpdateInterval() {
        return this.updateInterval * 60000L;
    }

    private void reschedule() {
        this.cancelCurrent();
        this.schedule();
    }

    private void cancelCurrent() {
        if (this.current != null) {
            this.current.cancel();
            LOGGER.debug("Current {} canceled", (Object)UpdateTimerTask.class.getSimpleName());
        }
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            LOGGER.debug("Cache Update timer canceled.");
        }
    }

    public void destroy() {
        this.cancelCurrent();
        this.cancelTimer();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    private class UpdateTimerTask
    extends TimerTask {
        private UpdateTimerTask() {
        }

        @Override
        public void run() {
            try {
                AbstractSchedulingContentCacheController.this.update();
                LOGGER.info("Timertask: capabilities cache update successful!");
                AbstractSchedulingContentCacheController.this.schedule();
            }
            catch (OwsExceptionReport e) {
                LOGGER.error("Fatal error: Timertask couldn't update capabilities cache! Switch log level to DEBUG to get more details.");
                LOGGER.debug("Exception thrown", (Throwable)e);
            }
        }
    }
}

