/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.n52.faroe.ConfigurationError;
import org.n52.iceland.util.LocalizedLazyThreadSafeProducer;
import org.n52.janmayen.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LazyThreadSafeProducer<T>
implements Producer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalizedLazyThreadSafeProducer.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private T t;

    protected void setRecreate() {
        LOG.trace("Removing internal object to recreate it. Old object: {}", this.t);
        this.lock.writeLock().lock();
        try {
            this.t = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() throws ConfigurationError {
        this.lock.readLock().lock();
        try {
            if (this.t != null) {
                T t = this.t;
                return t;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            if (this.t == null) {
                this.t = this.create();
                LOG.trace("Created a new object: {}", this.t);
            }
            this.lock.readLock().lock();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try {
            T t = this.t;
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected abstract T create() throws ConfigurationError;
}

