/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.cache.ctrl.persistence;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.iceland.cache.ContentCache;
import org.n52.iceland.cache.ctrl.persistence.AbstractPersistingCachePersistenceStrategy;
import org.n52.janmayen.GroupedAndNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class AsyncCachePersistenceStrategy
extends AbstractPersistingCachePersistenceStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncCachePersistenceStrategy.class);
    private static final TimeUnit WRITE_DELAY_UNITS = TimeUnit.SECONDS;
    private long writeDelay = 30L;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new GroupedAndNamedThreadFactory("cache-persister"));
    private final AtomicReference<ContentCache> cacheReference = new AtomicReference();
    private Updater updater;

    @Override
    public void init() {
        super.init();
        this.updater = new Updater();
        this.executor.schedule(this.updater, this.writeDelay, WRITE_DELAY_UNITS);
    }

    @Setting(value="service.cachePersistenceDelay")
    public void setDelay(int delay) {
        if (delay <= 1) {
            throw new ConfigurationError("The write delay has be greater than 1 second.", new Object[0]);
        }
        this.writeDelay = delay;
    }

    @Override
    public void persistOnPartialUpdate(ContentCache cache) {
        this.cacheReference.set(cache);
    }

    @Override
    public void persistOnCompleteUpdate(ContentCache cache) {
        this.cacheReference.set(cache);
    }

    @Override
    public void persistOnShutdown(ContentCache cache) {
        this.updater.setReschedule(false);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(this.writeDelay, WRITE_DELAY_UNITS);
        }
        catch (InterruptedException ie) {
            LOGGER.debug("Executor awaitTermination() was interrupted!", (Throwable)ie);
        }
        this.cacheReference.set(null);
        this.persistCache(cache);
    }

    private class Updater
    implements Runnable {
        private boolean reschedule = true;

        private Updater() {
        }

        public boolean isReschedule() {
            return this.reschedule;
        }

        public void setReschedule(boolean reschedule) {
            this.reschedule = reschedule;
        }

        @Override
        public void run() {
            ContentCache cache = AsyncCachePersistenceStrategy.this.cacheReference.getAndSet(null);
            if (cache != null) {
                AsyncCachePersistenceStrategy.this.persistCache(cache);
            }
            if (this.isReschedule()) {
                AsyncCachePersistenceStrategy.this.executor.schedule(this, AsyncCachePersistenceStrategy.this.writeDelay, WRITE_DELAY_UNITS);
            }
        }
    }
}

