/*
 * Decompiled with CFR 0.152.
 */
package org.n52.iceland.binding;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import org.n52.iceland.binding.SimpleBinding;
import org.n52.iceland.coding.DocumentBuilderProvider;
import org.n52.iceland.coding.decode.OwsDecodingException;
import org.n52.iceland.util.http.HttpUtils;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.InvalidParameterValueException;
import org.n52.shetland.ogc.ows.exception.MissingParameterValueException;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.util.StringHelper;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceOperationDecoderKey;
import org.n52.svalbard.decode.XmlStringOperationDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractXmlBinding<T>
extends SimpleBinding {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXmlBinding.class);
    private DocumentBuilderProvider documentFactory;

    @Inject
    public void setDocumentFactory(DocumentBuilderProvider documentFactory) {
        this.documentFactory = documentFactory;
    }

    protected T decode(HttpServletRequest request) throws OwsExceptionReport {
        String characterEncoding = this.getCharacterEncoding(request);
        String xmlString = this.xmlToString(request, characterEncoding);
        LOGGER.debug("XML-REQUEST: {}", (Object)xmlString);
        DecoderKey key = this.getDecoderKey(xmlString, characterEncoding);
        LOGGER.trace("Found decoder key: {}", (Object)key);
        Decoder decoder = this.getDecoder(key);
        if (decoder == null) {
            String opOrType = null;
            Optional<Object> service = Optional.empty();
            if (key instanceof XmlNamespaceOperationDecoderKey) {
                XmlNamespaceOperationDecoderKey xmlNamespaceKey = (XmlNamespaceOperationDecoderKey)key;
                opOrType = xmlNamespaceKey.getType();
            } else if (key instanceof XmlStringOperationDecoderKey) {
                XmlStringOperationDecoderKey xmlStringKey = (XmlStringOperationDecoderKey)key;
                opOrType = xmlStringKey.getOperation();
                service = Optional.of(xmlStringKey.getService());
            }
            if (OWSConstants.Operations.GetCapabilities.toString().equalsIgnoreCase(opOrType)) {
                if (service.isPresent()) {
                    throw new InvalidParameterValueException((Enum)OWSConstants.GetCapabilitiesParams.service, (String)service.get()).withMessage("The service '%s' is not supported.", new Object[]{service});
                }
                throw new MissingParameterValueException((Enum)OWSConstants.GetCapabilitiesParams.service).withMessage("The parameter '%s' is missing.", new Object[]{OWSConstants.GetCapabilitiesParams.service});
            }
            throw new InvalidParameterValueException().withMessage("No decoder found for incoming message based on derived decoder key: %s\nMessage: %s", new Object[]{key, xmlString});
        }
        LOGGER.trace("Using decoder: {}", decoder);
        try {
            return (T)decoder.decode((Object)xmlString);
        }
        catch (OwsDecodingException ex) {
            throw ex.getCause();
        }
        catch (DecodingException ex) {
            throw new NoApplicableCodeException().withMessage(ex.getMessage(), new Object[0]).causedBy((Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected DecoderKey getDecoderKey(String xmlContent, String characterEncoding) throws CodedException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xmlContent.getBytes(characterEncoding));){
            Document document = this.documentFactory.newDocumentBuilder().parse(stream);
            Element element = document.getDocumentElement();
            element.normalize();
            if (element.hasAttributes() && element.hasAttribute(OWSConstants.RequestParams.service.name())) {
                XmlStringOperationDecoderKey decoderKey;
                OwsOperationKey operationKey = this.getOperationKey(element);
                XmlStringOperationDecoderKey xmlStringOperationDecoderKey = decoderKey = new XmlStringOperationDecoderKey(operationKey, this.getDefaultContentType());
                return xmlStringOperationDecoderKey;
            }
            XmlNamespaceOperationDecoderKey xmlNamespaceOperationDecoderKey = this.getNamespaceOperationDecoderKey(element);
            return xmlNamespaceOperationDecoderKey;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new NoApplicableCodeException().causedBy((Throwable)e).withMessage("An error occured when parsing the request! Message: %s", new Object[]{e.getMessage()});
        }
    }

    private XmlNamespaceOperationDecoderKey getNamespaceOperationDecoderKey(Element element) {
        String nodeName = element.getNodeName();
        if (Strings.isNullOrEmpty((String)element.getNamespaceURI())) {
            String elementName;
            String[] splittedNodeName = nodeName.split(":");
            String prefix = null;
            if (splittedNodeName.length == 2) {
                prefix = splittedNodeName[0];
                elementName = splittedNodeName[1];
            } else {
                elementName = splittedNodeName[0];
            }
            String name = Strings.isNullOrEmpty((String)prefix) ? "xmlns" : "xmlns:" + prefix;
            String namespace = element.getAttribute(name);
            return new XmlNamespaceOperationDecoderKey(namespace, elementName);
        }
        return new XmlNamespaceOperationDecoderKey(element.getNamespaceURI(), nodeName.substring(nodeName.indexOf(58) + 1));
    }

    protected OwsOperationKey getOperationKey(Element element) {
        String service = null;
        String version = null;
        String operation = null;
        if (element.hasAttributes()) {
            service = Strings.emptyToNull((String)element.getAttribute(OWSConstants.RequestParams.service.name()));
            version = Strings.emptyToNull((String)element.getAttribute(OWSConstants.RequestParams.version.name()));
            if (!Strings.isNullOrEmpty((String)service)) {
                String nodeName = element.getNodeName();
                operation = nodeName.substring(nodeName.indexOf(58) + 1);
            }
        }
        return new OwsOperationKey(service, version, operation);
    }

    protected String xmlToString(HttpServletRequest request, String characterEncoding) throws OwsExceptionReport {
        try {
            if (request.getParameterMap().isEmpty()) {
                return StringHelper.convertStreamToString((InputStream)HttpUtils.getInputStream(request), (String)characterEncoding);
            }
            return this.parseHttpPostBodyWithParameter(request.getParameterNames(), request.getParameterMap());
        }
        catch (IOException ioe) {
            throw new NoApplicableCodeException().causedBy((Throwable)ioe).withMessage("Error while reading request! Message: %s", new Object[]{ioe.getMessage()});
        }
    }

    private String getCharacterEncoding(HttpServletRequest request) {
        return !Strings.isNullOrEmpty((String)request.getCharacterEncoding()) ? request.getCharacterEncoding() : "UTF-8";
    }

    private String parseHttpPostBodyWithParameter(Enumeration<?> paramNames, Map<?, ?> parameterMap) throws OwsExceptionReport {
        if (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (OWSConstants.RequestParams.request.name().equalsIgnoreCase(paramName)) {
                String[] paramValues = (String[])parameterMap.get(paramName);
                if (paramValues.length == 1) {
                    return paramValues[0];
                }
                String message = "The parameter '%s' has more than one value or is empty for HTTP-Post requests to this service!";
                throw new NoApplicableCodeException().withMessage(message, new Object[]{paramName});
            }
            throw new NoApplicableCodeException().withMessage("The parameter '%s' is not supported for HTTP-Post requests to this service!", new Object[]{paramName});
        }
        throw new NoApplicableCodeException();
    }
}

