/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api;

import com.google.common.base.Strings;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import org.mythtv.services.api.ApiVersion;

public class ServerVersionQuery {
    private static final String MYTHTV_SERVER_HEADER = "Server";
    private static final String MYTHTV_SERVER_MYTHVERSION = "MythTV";

    public static ApiVersion getMythVersion(String baseUri) throws IOException {
        String version;
        int idx;
        String serverHeader;
        OkHttpClient client = new OkHttpClient();
        StringBuilder urlBuilder = new StringBuilder(baseUri);
        if (!baseUri.endsWith("/")) {
            urlBuilder.append("/");
        }
        urlBuilder.append("Myth/GetHostName");
        Request request = new Request.Builder().url(urlBuilder.toString()).addHeader("User-Agent", "MythTv Service API").addHeader("Connection", "Close").build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful() && !Strings.isNullOrEmpty((String)(serverHeader = response.header(MYTHTV_SERVER_HEADER))) && (idx = serverHeader.indexOf(MYTHTV_SERVER_MYTHVERSION)) >= 0 && (version = serverHeader.substring(idx += MYTHTV_SERVER_MYTHVERSION.length())).contains("0.27")) {
            return ApiVersion.v027;
        }
        return ApiVersion.NotSupported;
    }

    public static boolean isServerReachable(String baseUrl) throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(baseUrl).addHeader("User-Agent", "MythTv Service API Server Reaching").addHeader("Connection", "Close").build();
        Response response = client.newCall(request).execute();
        return response.isSuccessful();
    }
}

