/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api;

import com.google.common.base.Strings;
import com.squareup.okhttp.OkHttpClient;
import java.util.Map;
import org.mythtv.services.api.ApiVersion;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.EtagInterceptingOkClient;
import org.mythtv.services.api.JacksonUtils;
import org.mythtv.services.api.MythTvApi027Context;
import org.mythtv.services.api.MythTvApi028Context;
import org.mythtv.services.api.MythTvServiceApiException;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

public abstract class MythTvApiContext {
    public static final int DEFAULT_API_PORT = 6544;
    public static final int ETAG_MATCH_HTTP_RESPONSE_CODE = 304;
    private static JacksonConverter CONVERTER = new JacksonConverter(JacksonUtils.initObjectMapper());
    protected String backendHost;
    protected int backendPort;
    protected EtagInterceptingOkClient client;
    protected RestAdapter restAdapter;

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getBackendPort() {
        return this.backendPort;
    }

    public String getBackendHost() {
        return this.backendHost;
    }

    public ETagInfo getEtag(String requestId, boolean createIfMissing) {
        ETagInfo eTagInfo = this.client.getEtags().get(requestId);
        if (!createIfMissing) {
            return eTagInfo;
        }
        if (eTagInfo == null) {
            eTagInfo = ETagInfo.createEmptyETag();
            this.client.getEtags().put(requestId, eTagInfo);
        }
        return eTagInfo;
    }

    public Map<String, ETagInfo> getEtags() {
        return this.client.getEtags();
    }

    protected void initialize() {
        StringBuilder builder = new StringBuilder("http://");
        builder.append(this.backendHost).append(":").append(this.backendPort);
        this.client = new EtagInterceptingOkClient(new OkHttpClient());
        this.restAdapter = new RestAdapter.Builder().setClient((Client)this.client).setEndpoint(builder.toString()).setConverter((Converter)CONVERTER).build();
    }

    public static class Builder {
        private ApiVersion apiVersion;
        private String hostName;
        private int port = 6544;

        private Builder() {
        }

        public MythTvApiContext build() throws MythTvServiceApiException {
            if (Strings.isNullOrEmpty((String)this.hostName)) {
                throw new MythTvServiceApiException("hostname must be set and cannot be null or empty");
            }
            if (this.apiVersion == null) {
                throw new MythTvServiceApiException("apiVersion must be set and cannot be null");
            }
            switch (this.apiVersion) {
                case v027: 
                case v028: {
                    break;
                }
                default: {
                    throw new MythTvServiceApiException("apiVersion " + (Object)((Object)this.apiVersion) + "is not supported");
                }
            }
            if (this.port <= 0) {
                throw new MythTvServiceApiException("port " + this.port + " is invalid");
            }
            switch (this.apiVersion) {
                case v027: {
                    MythTvApi027Context context = new MythTvApi027Context();
                    context.backendHost = this.hostName;
                    context.backendPort = this.port;
                    ((MythTvApiContext)context).initialize();
                    return context;
                }
                case v028: {
                    MythTvApi028Context context = new MythTvApi028Context();
                    context.backendHost = this.hostName;
                    context.backendPort = this.port;
                    ((MythTvApiContext)context).initialize();
                    return context;
                }
            }
            return null;
        }

        public Builder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setVersion(ApiVersion apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }
    }
}

