/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api;

import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mythtv.services.api.ETagInfo;
import retrofit.client.Header;
import retrofit.client.OkClient;
import retrofit.client.Request;
import retrofit.client.Response;

public class EtagInterceptingOkClient
extends OkClient {
    private static final String ETAG_REQUEST_HEADER = "If-None-Match";
    private static final String ETAG_RESPONSE_HEADER = "ETag";
    private static final String MYTH_REQUEST_ID_HEADER = "MYTH_REQUEST_ID";
    private Map<String, ETagInfo> etags = new HashMap<String, ETagInfo>();

    public EtagInterceptingOkClient() {
    }

    public EtagInterceptingOkClient(OkHttpClient client) {
        super(client);
    }

    public Response execute(Request request) throws IOException {
        String requestId = null;
        String etag = null;
        for (Header header : request.getHeaders()) {
            switch (header.getName()) {
                case "MYTH_REQUEST_ID": {
                    requestId = header.getValue();
                    break;
                }
                case "If-None-Match": {
                    etag = header.getValue();
                }
            }
        }
        if (requestId == null) {
            return super.execute(request);
        }
        ETagInfo eTagInfo = this.etags.get(requestId);
        if (eTagInfo == null) {
            eTagInfo = ETagInfo.createEmptyETag();
            this.etags.put(requestId, eTagInfo);
        }
        eTagInfo.setETag(etag);
        Response response = super.execute(request);
        List headers = response.getHeaders();
        for (Header h : headers) {
            if (!ETAG_RESPONSE_HEADER.equalsIgnoreCase(h.getName())) continue;
            eTagInfo.setETag(h.getValue());
            break;
        }
        return response;
    }

    public Map<String, ETagInfo> getEtags() {
        return this.etags;
    }
}

