/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v027.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.AbstractOperations;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v027.GuideOperations;
import org.mythtv.services.api.v027.beans.Program;
import org.mythtv.services.api.v027.beans.ProgramGuide;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class GuideTemplate
extends AbstractOperations
implements GuideOperations {
    private final RestOperations restOperations;

    public GuideTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase + "Guide/");
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<String> getChannelIcon(Integer chanId, Integer width, Integer height, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (chanId != null) {
            parameters.add((Object)"ChanId", (Object)chanId.toString());
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetChannelIcon", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Program> getProgramDetails(Integer chanId, DateTime startTime, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (chanId != null) {
            parameters.add((Object)"ChanId", (Object)chanId.toString());
        }
        if (startTime != null) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetProgramDetails", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Program.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramGuide> getProgramGuide(DateTime startTime, DateTime endTime, Integer startChanId, Integer numChannels, Boolean details, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (startTime != null) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        if (endTime != null) {
            parameters.add((Object)"EndTime", (Object)this.convertUtcAndFormat(endTime));
        }
        if (startChanId != null) {
            parameters.add((Object)"StartChanId", (Object)startChanId.toString());
        }
        if (numChannels != null) {
            parameters.add((Object)"NumChannels", (Object)numChannels.toString());
        }
        if (details != null) {
            parameters.add((Object)"Details", (Object)details.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetProgramGuide", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ProgramGuide.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }
}

