/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026.impl;

import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v026.Bool;
import org.mythtv.services.api.v026.VideoOperations;
import org.mythtv.services.api.v026.beans.BlurayInfoWrapper;
import org.mythtv.services.api.v026.beans.VideoLookupList;
import org.mythtv.services.api.v026.beans.VideoMetaDataInfoWrapper;
import org.mythtv.services.api.v026.beans.VideoMetadataInfoList;
import org.mythtv.services.api.v026.impl.AbstractVideoOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class VideoTemplate
extends AbstractVideoOperations
implements VideoOperations {
    private final RestOperations restOperations;

    public VideoTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Bool> addVideo(String filename, String hostname) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)filename);
        parameters.add((Object)"HostName", (Object)hostname);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.ADD_VIDEO.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<BlurayInfoWrapper> getBluray(String path, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Path", (Object)path);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_BLURAY.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), BlurayInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetaDataInfoWrapper> getVideo(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoMetaDataInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetaDataInfoWrapper> getVideoByFilename(String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)filename);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO_BY_FILENAME.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoMetaDataInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetadataInfoList> getVideoList(boolean descending, int startIndex, int count, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Descending", (Object)Boolean.toString(descending));
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)String.valueOf(startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)String.valueOf(count));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoMetadataInfoList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoLookupList> lookupVideo(String title, String subtitle, String inetRef, int season, int episode, String grabberType, boolean allowGeneric, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Title", (Object)title);
        if (null != subtitle && !"".equals(subtitle)) {
            parameters.add((Object)"Subtitle", (Object)subtitle);
        }
        if (null != inetRef && !"".equals(inetRef)) {
            parameters.add((Object)"Inetref", (Object)inetRef);
        }
        if (season > 0) {
            parameters.add((Object)"Season", (Object)String.valueOf(season));
        }
        if (episode > 0) {
            parameters.add((Object)"Episode", (Object)String.valueOf(episode));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.LOOKUP_VIDEO.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoLookupList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeVideoFromDatabase(int id) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.REMOVE_VIDEO_FROM_DB.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    public static enum Endpoint {
        ADD_VIDEO("AddVideo"),
        GET_BLURAY("GetBluray"),
        GET_VIDEO("GetVideo"),
        GET_VIDEO_BY_FILENAME("GetVideoByFileName"),
        GET_VIDEO_LIST("GetVideoList"),
        LOOKUP_VIDEO("LookupVideo"),
        REMOVE_VIDEO_FROM_DB("RemoveVideoFromDB");

        private String endpoint;

        private Endpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

