/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026.impl;

import java.net.URI;
import org.joda.time.DateTime;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v026.Bool;
import org.mythtv.services.api.v026.FrontendOperations;
import org.mythtv.services.api.v026.beans.FrontendActionList;
import org.mythtv.services.api.v026.beans.FrontendStatus;
import org.mythtv.services.api.v026.impl.AbstractFrontendOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class FrontendTemplate
extends AbstractFrontendOperations
implements FrontendOperations {
    private final RestOperations restOperations;

    public FrontendTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<FrontendStatus> getStatus(String frontedApiUrlBase, ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(frontedApiUrlBase + "/Frontend/GetStatus", HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), FrontendStatus.class, new Object[0]);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> sendMessage(String frontedApiUrlBase, String message) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Message", (Object)message);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(frontedApiUrlBase + "/Frontend/SendMessage", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> sendAction(String frontedApiUrlBase, String action, String file, int width, int height) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Action", (Object)action);
        if (null != file) {
            parameters.add((Object)"File", (Object)file);
        }
        if (width > 0 && height > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(frontedApiUrlBase + "/Frontend/SendAction", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<FrontendActionList> getActionList(String frontedApiUrlBase, ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(frontedApiUrlBase + "/Frontend/GetActionList"), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), FrontendActionList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> playRecording(String frontedApiUrlBase, int channelId, DateTime startTime) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)String.valueOf(channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        URI uri = this.buildUri(frontedApiUrlBase + "/Frontend/PlayRecording", (MultiValueMap<String, String>)parameters);
        ResponseEntity responseEntity = this.restOperations.exchange(uri, HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> playVideo(String frontedApiUrlBase, String id, boolean useBookmark) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)id.toString());
        if (useBookmark) {
            parameters.add((Object)"UseBookmark", (Object)"1");
        }
        URI uri = this.buildUri(frontedApiUrlBase + "/Frontend/PlayVideo", (MultiValueMap<String, String>)parameters);
        ResponseEntity responseEntity = this.restOperations.exchange(uri, HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }
}

