/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v026.Bool;
import org.mythtv.services.api.v026.ContentOperations;
import org.mythtv.services.api.v026.StringList;
import org.mythtv.services.api.v026.beans.ArtworkInfoList;
import org.mythtv.services.api.v026.beans.ArtworkInfos;
import org.mythtv.services.api.v026.beans.LiveStreamInfo;
import org.mythtv.services.api.v026.beans.LiveStreamInfoWrapper;
import org.mythtv.services.api.v026.beans.LiveStreamInfos;
import org.mythtv.services.api.v026.impl.AbstractContentOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class ContentTemplate
extends AbstractContentOperations
implements ContentOperations {
    private final RestOperations restOperations;

    public ContentTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> addLiveStream(String storageGroup, String filename, String hostname, int maxSegments, int width, int height, int bitrate, int audioBitrate, int sampleRate) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)filename);
        if (storageGroup != null) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        if (hostname != null) {
            parameters.add((Object)"HostName", (Object)hostname);
        }
        if (maxSegments > 0) {
            parameters.add((Object)"MaxSegments", (Object)String.valueOf(maxSegments));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        if (bitrate > 0) {
            parameters.add((Object)"Bitrate", (Object)String.valueOf(bitrate));
        }
        if (audioBitrate > 0) {
            parameters.add((Object)"AudioBitrate", (Object)String.valueOf(audioBitrate));
        }
        if (sampleRate > 0) {
            parameters.add((Object)"SampleRate", (Object)String.valueOf(sampleRate));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.ADD_LIVE_STREAM.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), LiveStreamInfoWrapper.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> addRecordingLiveStream(int channelId, DateTime startTime, int maxSegments, int width, int height, int bitrate, int audioBitrate, int sampleRate) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)String.valueOf(channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        if (maxSegments > 0) {
            parameters.add((Object)"MaxSegments", (Object)String.valueOf(maxSegments));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        if (bitrate > 0) {
            parameters.add((Object)"Bitrate", (Object)String.valueOf(bitrate));
        }
        if (audioBitrate > 0) {
            parameters.add((Object)"AudioBitrate", (Object)String.valueOf(audioBitrate));
        }
        if (sampleRate > 0) {
            parameters.add((Object)"SampleRate", (Object)String.valueOf(sampleRate));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.ADD_RECORDING_LIVE_STREAM.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), LiveStreamInfoWrapper.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> addVideoLiveStream(int id, int maxSegments, int width, int height, int bitrate, int audioBitrate, int sampleRate) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        if (maxSegments > 0) {
            parameters.add((Object)"MaxSegments", (Object)String.valueOf(maxSegments));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        if (bitrate > 0) {
            parameters.add((Object)"Bitrate", (Object)String.valueOf(bitrate));
        }
        if (audioBitrate > 0) {
            parameters.add((Object)"AudioBitrate", (Object)String.valueOf(audioBitrate));
        }
        if (sampleRate > 0) {
            parameters.add((Object)"SampleRate", (Object)String.valueOf(sampleRate));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.ADD_VIDEO_LIVE_STREAM.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), LiveStreamInfoWrapper.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> downloadFile(String url, String storageGroup, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        parameters.add((Object)"URL", (Object)url);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.DOWNLOAD_FILE.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getAlbumArt(int id, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_ALBUM_ART.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getFile(String storageGroup, String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        if (null != filename && !"".equals(filename)) {
            parameters.add((Object)"FileName", (Object)filename);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_FILE.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<StringList> getFileList(String storageGroup, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_FILE_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), StringList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfos> getFilteredLiveStreamList(String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)filename);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_FILTERED_LIVE_STREAM_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), LiveStreamInfos.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getHash(String storageGroup, String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        parameters.add((Object)"FileName", (Object)filename);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_HASH.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), String.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getImageFile(String storageGroup, String filename, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        parameters.add((Object)"FileName", (Object)filename);
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_IMAGE_FILE.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> getLiveStream(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_LIVE_STREAM.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), LiveStreamInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfos> getLiveStreamList(ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_LIVE_STREAM_LIST.getEndpoint()), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), LiveStreamInfos.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getMusic(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_MUSIC.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getPreviewImage(int channelId, DateTime startTime, int width, int height, int secondsIn, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)String.valueOf(channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        if (secondsIn > 0) {
            parameters.add((Object)"SecsIn", (Object)String.valueOf(secondsIn));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_PREVIEW_IMAGE.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArtworkInfos> getProgramArtworkList(String inetRef, int season, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Inetref", (Object)inetRef);
        if (season > 0) {
            parameters.add((Object)"Season", (Object)String.valueOf(season));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_PROGRAM_ARTWORK_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), ArtworkInfos.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getRecording(int channelId, DateTime startTime, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)String.valueOf(channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_RECORDING.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getRecordingArtwork(String type, String inetRef, int season, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Inetref", (Object)inetRef);
        if (null != type && !"".equals(type)) {
            parameters.add((Object)"Type", (Object)type);
        }
        if (season > 0) {
            parameters.add((Object)"Season", (Object)String.valueOf(season));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_RECORDING_ARTWORK.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArtworkInfoList> getRecordingArtworkList(int channelId, DateTime startTime, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)String.valueOf(channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_RECORDING_ARTWORK_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), ArtworkInfoList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getVideo(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getVideoArtwork(String type, int id, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)String.valueOf(id));
        if (null != type && !"".equals(type)) {
            parameters.add((Object)"Type", (Object)type);
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)String.valueOf(width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)String.valueOf(height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO_ARTWORK.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeLiveStream(int id) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.REMOVE_LIVE_STREAM.getEndpoint(), "Id", String.valueOf(id)), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfo> stopLiveStream(int id) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.STOP_LIVE_STREAM.getEndpoint(), "Id", String.valueOf(id)), HttpMethod.GET, this.getRequestEntity(null, new MediaType[0]), LiveStreamInfo.class);
        return responseEntity;
    }

    public static enum Endpoint {
        ADD_LIVE_STREAM("AddLiveStream"),
        ADD_RECORDING_LIVE_STREAM("AddRecordingLiveStream"),
        ADD_VIDEO_LIVE_STREAM("AddVideoLiveStream"),
        DOWNLOAD_FILE("DownloadFile"),
        GET_ALBUM_ART("GetAlbumArt"),
        GET_FILE("GetFile"),
        GET_FILE_LIST("GetFileList"),
        GET_FILTERED_LIVE_STREAM_LIST("GetFilteredLiveStreamList"),
        GET_HASH("GetHash"),
        GET_IMAGE_FILE("GetImageFile"),
        GET_LIVE_STREAM("GetLiveStream"),
        GET_LIVE_STREAM_LIST("GetLiveStreamList"),
        GET_MUSIC("GetMusic"),
        GET_PREVIEW_IMAGE("GetPreviewImage"),
        GET_PROGRAM_ARTWORK_LIST("GetProgramArtworkList"),
        GET_RECORDING("GetRecording"),
        GET_RECORDING_ARTWORK("GetRecordingArtwork"),
        GET_RECORDING_ARTWORK_LIST("GetRecordingArtworkList"),
        GET_VIDEO("GetVideo"),
        GET_VIDEO_ARTWORK("GetVideoArtwork"),
        REMOVE_LIVE_STREAM("RemoveLiveStream"),
        STOP_LIVE_STREAM("StopLiveStream");

        private String endpoint;

        private Endpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

