/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v025.impl;

import org.mythtv.services.api.AbstractOperations;
import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.Int;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v025.CaptureOperations;
import org.mythtv.services.api.v025.beans.CaptureCard;
import org.mythtv.services.api.v025.beans.CaptureCardList;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class CaptureTemplate
extends AbstractOperations
implements CaptureOperations {
    private final RestOperations restOperations;

    public CaptureTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase + "Capture/");
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Int> addCaptureCard(String videoDevice, String audioDevice, String vBIDevice, String cardType, Integer audioRateLimit, String hostName, Integer dVBSWFilter, Integer dVBSatType, Boolean dVBWaitForSeqStart, Boolean skipBTAudio, Boolean dVBOnDemand, Integer dVBDiSEqCType, Integer firewireSpeed, String firewireModel, Integer firewireConnection, Integer signalTimeout, Integer channelTimeout, Integer dVBTuningDelay, Integer contrast, Integer brightness, Integer colour, Integer hue, Integer diSEqCId, Boolean dVBEITScan) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (videoDevice != null && !videoDevice.isEmpty()) {
            parameters.add((Object)"VideoDevice", (Object)videoDevice);
        }
        if (audioDevice != null && !audioDevice.isEmpty()) {
            parameters.add((Object)"AudioDevice", (Object)audioDevice);
        }
        if (vBIDevice != null && !vBIDevice.isEmpty()) {
            parameters.add((Object)"VBIDevice", (Object)vBIDevice);
        }
        if (cardType != null && !cardType.isEmpty()) {
            parameters.add((Object)"CardType", (Object)cardType);
        }
        if (audioRateLimit != null) {
            parameters.add((Object)"AudioRateLimit", (Object)audioRateLimit.toString());
        }
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (dVBSWFilter != null) {
            parameters.add((Object)"DVBSWFilter", (Object)dVBSWFilter.toString());
        }
        if (dVBSatType != null) {
            parameters.add((Object)"DVBSatType", (Object)dVBSatType.toString());
        }
        if (dVBWaitForSeqStart != null) {
            parameters.add((Object)"DVBWaitForSeqStart", (Object)dVBWaitForSeqStart.toString());
        }
        if (skipBTAudio != null) {
            parameters.add((Object)"SkipBTAudio", (Object)skipBTAudio.toString());
        }
        if (dVBOnDemand != null) {
            parameters.add((Object)"DVBOnDemand", (Object)dVBOnDemand.toString());
        }
        if (dVBDiSEqCType != null) {
            parameters.add((Object)"DVBDiSEqCType", (Object)dVBDiSEqCType.toString());
        }
        if (firewireSpeed != null) {
            parameters.add((Object)"FirewireSpeed", (Object)firewireSpeed.toString());
        }
        if (firewireModel != null && !firewireModel.isEmpty()) {
            parameters.add((Object)"FirewireModel", (Object)firewireModel);
        }
        if (firewireConnection != null) {
            parameters.add((Object)"FirewireConnection", (Object)firewireConnection.toString());
        }
        if (signalTimeout != null) {
            parameters.add((Object)"SignalTimeout", (Object)signalTimeout.toString());
        }
        if (channelTimeout != null) {
            parameters.add((Object)"ChannelTimeout", (Object)channelTimeout.toString());
        }
        if (dVBTuningDelay != null) {
            parameters.add((Object)"DVBTuningDelay", (Object)dVBTuningDelay.toString());
        }
        if (contrast != null) {
            parameters.add((Object)"Contrast", (Object)contrast.toString());
        }
        if (brightness != null) {
            parameters.add((Object)"Brightness", (Object)brightness.toString());
        }
        if (colour != null) {
            parameters.add((Object)"Colour", (Object)colour.toString());
        }
        if (hue != null) {
            parameters.add((Object)"Hue", (Object)hue.toString());
        }
        if (diSEqCId != null) {
            parameters.add((Object)"DiSEqCId", (Object)diSEqCId.toString());
        }
        if (dVBEITScan != null) {
            parameters.add((Object)"DVBEITScan", (Object)dVBEITScan.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddCaptureCard", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Int.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Int> addCardInput(Integer cardId, Integer sourceId, String inputName, String externalCommand, String changerDevice, String changerModel, String hostName, String tuneChan, String startChan, String displayName, Boolean dishnetEIT, Integer recPriority, Integer quicktune, Integer schedOrder, Integer liveTVOrder) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (cardId != null) {
            parameters.add((Object)"CardId", (Object)cardId.toString());
        }
        if (sourceId != null) {
            parameters.add((Object)"SourceId", (Object)sourceId.toString());
        }
        if (inputName != null && !inputName.isEmpty()) {
            parameters.add((Object)"InputName", (Object)inputName);
        }
        if (externalCommand != null && !externalCommand.isEmpty()) {
            parameters.add((Object)"ExternalCommand", (Object)externalCommand);
        }
        if (changerDevice != null && !changerDevice.isEmpty()) {
            parameters.add((Object)"ChangerDevice", (Object)changerDevice);
        }
        if (changerModel != null && !changerModel.isEmpty()) {
            parameters.add((Object)"ChangerModel", (Object)changerModel);
        }
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (tuneChan != null && !tuneChan.isEmpty()) {
            parameters.add((Object)"TuneChan", (Object)tuneChan);
        }
        if (startChan != null && !startChan.isEmpty()) {
            parameters.add((Object)"StartChan", (Object)startChan);
        }
        if (displayName != null && !displayName.isEmpty()) {
            parameters.add((Object)"DisplayName", (Object)displayName);
        }
        if (dishnetEIT != null) {
            parameters.add((Object)"DishnetEIT", (Object)dishnetEIT.toString());
        }
        if (recPriority != null) {
            parameters.add((Object)"RecPriority", (Object)recPriority.toString());
        }
        if (quicktune != null) {
            parameters.add((Object)"Quicktune", (Object)quicktune.toString());
        }
        if (schedOrder != null) {
            parameters.add((Object)"SchedOrder", (Object)schedOrder.toString());
        }
        if (liveTVOrder != null) {
            parameters.add((Object)"LiveTVOrder", (Object)liveTVOrder.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddCardInput", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Int.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<CaptureCard> getCaptureCard(Integer cardId, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (cardId != null) {
            parameters.add((Object)"CardId", (Object)cardId.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetCaptureCard", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), CaptureCard.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<CaptureCardList> getCaptureCardList(String hostName, String cardType, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (cardType != null && !cardType.isEmpty()) {
            parameters.add((Object)"CardType", (Object)cardType);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetCaptureCardList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), CaptureCardList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeCaptureCard(Integer cardId) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (cardId != null) {
            parameters.add((Object)"CardId", (Object)cardId.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveCaptureCard", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeCardInput(Integer cardInputId) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (cardInputId != null) {
            parameters.add((Object)"CardInputId", (Object)cardInputId.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveCardInput", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> updateCaptureCard(Integer cardId, String setting, String value) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (cardId != null) {
            parameters.add((Object)"CardId", (Object)cardId.toString());
        }
        if (setting != null && !setting.isEmpty()) {
            parameters.add((Object)"Setting", (Object)setting);
        }
        if (value != null && !value.isEmpty()) {
            parameters.add((Object)"Value", (Object)value);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("UpdateCaptureCard", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> updateCardInput(Integer cardInputId, String setting, String value) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (cardInputId != null) {
            parameters.add((Object)"CardInputId", (Object)cardInputId.toString());
        }
        if (setting != null && !setting.isEmpty()) {
            parameters.add((Object)"Setting", (Object)setting);
        }
        if (value != null && !value.isEmpty()) {
            parameters.add((Object)"Value", (Object)value);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("UpdateCardInput", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }
}

