/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v027.status.beans;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.joda.time.ReadableInstant;
import org.mythtv.services.api.v027.status.beans.Program;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="Channel")
public class ChannelInfo
implements Serializable,
Comparable<ChannelInfo> {
    private static final long serialVersionUID = 5939218201237085127L;
    private static Logger LOGGER = Logger.getLogger("ChannelInfo");
    @JsonProperty(value="ChanId")
    @Attribute(name="chanId")
    private int channelId;
    @JsonProperty(value="ChanNum")
    @Attribute(name="chanNum")
    private String channelNumber;
    @JsonProperty(value="CallSign")
    @Attribute(name="callSign")
    private String callSign;
    @JsonProperty(value="IconURL")
    private String iconUrl;
    @JsonProperty(value="ChannelName")
    @Attribute(name="channelName")
    private String channelName;
    @JsonProperty(value="MplexId")
    private int multiplexId;
    @JsonProperty(value="TransportId")
    private int transportId;
    @JsonProperty(value="ServiceId")
    private int serviceId;
    @JsonProperty(value="NetworkId")
    private int networkId;
    @JsonProperty(value="ATSCMajorChan")
    private int atscMajorChannel;
    @JsonProperty(value="ATSCMinorChan")
    private int atscMinorChannel;
    @JsonProperty(value="Format")
    private String format;
    @JsonProperty(value="Modulation")
    private String modulation;
    @JsonProperty(value="Frequency")
    private int frequency;
    @JsonProperty(value="FrequencyId")
    private String frequencyId;
    @JsonProperty(value="FrequencyTable")
    private String frequenceTable;
    @JsonProperty(value="FineTune")
    private int fineTune;
    @JsonProperty(value="SIStandard")
    private String siStandard;
    @JsonProperty(value="ChanFilters")
    @Attribute(name="chanFilters")
    private String channelFilters;
    @JsonProperty(value="SourceId")
    @Attribute(name="sourceId")
    private int sourceId;
    @JsonProperty(value="InputId")
    @Attribute(name="inputId")
    private int inputId;
    @JsonProperty(value="CommFree")
    @Attribute(name="commFree")
    private int commercialFree;
    @JsonProperty(value="UseEIT")
    private boolean useEit;
    @JsonProperty(value="Visible")
    private boolean visable;
    @JsonProperty(value="XMLTVID")
    private String xmltvId;
    @JsonProperty(value="DefaultAuth")
    private String defaultAuth;
    @JsonProperty(value="Programs")
    private List<Program> programs;

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public String getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(String channelNumber) {
        this.channelNumber = channelNumber;
    }

    public String getCallSign() {
        return this.callSign;
    }

    public void setCallSign(String callSign) {
        this.callSign = callSign;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public int getMultiplexId() {
        return this.multiplexId;
    }

    public void setMultiplexId(int multiplexId) {
        this.multiplexId = multiplexId;
    }

    public int getTransportId() {
        return this.transportId;
    }

    public void setTransportId(int transportId) {
        this.transportId = transportId;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(int serviceId) {
        this.serviceId = serviceId;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    public int getAtscMajorChannel() {
        return this.atscMajorChannel;
    }

    public void setAtscMajorChannel(int atscMajorChannel) {
        this.atscMajorChannel = atscMajorChannel;
    }

    public int getAtscMinorChannel() {
        return this.atscMinorChannel;
    }

    public void setAtscMinorChannel(int atscMinorChannel) {
        this.atscMinorChannel = atscMinorChannel;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getModulation() {
        return this.modulation;
    }

    public void setModulation(String modulation) {
        this.modulation = modulation;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public String getFrequencyId() {
        return this.frequencyId;
    }

    public void setFrequencyId(String frequencyId) {
        this.frequencyId = frequencyId;
    }

    public String getFrequenceTable() {
        return this.frequenceTable;
    }

    public void setFrequenceTable(String frequenceTable) {
        this.frequenceTable = frequenceTable;
    }

    public int getFineTune() {
        return this.fineTune;
    }

    public void setFineTune(int fineTune) {
        this.fineTune = fineTune;
    }

    public String getSiStandard() {
        return this.siStandard;
    }

    public void setSiStandard(String siStandard) {
        this.siStandard = siStandard;
    }

    public String getChannelFilters() {
        return this.channelFilters;
    }

    public void setChannelFilters(String channelFilters) {
        this.channelFilters = channelFilters;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(int sourceId) {
        this.sourceId = sourceId;
    }

    public int getInputId() {
        return this.inputId;
    }

    public void setInputId(int inputId) {
        this.inputId = inputId;
    }

    public int getCommercialFree() {
        return this.commercialFree;
    }

    public void setCommercialFree(int commercialFree) {
        this.commercialFree = commercialFree;
    }

    public boolean isUseEit() {
        return this.useEit;
    }

    public void setUseEit(boolean useEit) {
        this.useEit = useEit;
    }

    public boolean isVisable() {
        return this.visable;
    }

    public void setVisable(boolean visable) {
        this.visable = visable;
    }

    public String getXmltvId() {
        return this.xmltvId;
    }

    public void setXmltvId(String xmltvId) {
        this.xmltvId = xmltvId;
    }

    public String getDefaultAuth() {
        return this.defaultAuth;
    }

    public void setDefaultAuth(String defaultAuth) {
        this.defaultAuth = defaultAuth;
    }

    public List<Program> getPrograms() {
        return this.programs;
    }

    public void setPrograms(List<Program> programs) {
        this.programs = programs;
        Collections.sort(programs, new Comparator<Program>(){

            @Override
            public int compare(Program o1, Program o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1.getStartTime() == null && o2.getStartTime() == null) {
                    return 0;
                }
                if (o1.getStartTime() == null) {
                    return -1;
                }
                if (o2.getStartTime() == null) {
                    return 1;
                }
                return o1.getStartTime().compareTo((ReadableInstant)o2.getStartTime());
            }
        });
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channelNumber == null ? 0 : this.channelNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelInfo other = (ChannelInfo)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(ChannelInfo arg) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == arg) {
            return 0;
        }
        if (arg == null) {
            return 1;
        }
        try {
            String sThisChannelNumber = this.channelNumber;
            sThisChannelNumber = sThisChannelNumber.replaceAll("\\D+", ".");
            String sOtherChannelNumber = arg.getChannelNumber();
            sOtherChannelNumber = sOtherChannelNumber.replaceAll("\\D+", ".");
            Double dThisChannelNumber = Double.parseDouble(sThisChannelNumber);
            Double dOtherChannelNumber = Double.parseDouble(sOtherChannelNumber);
            if (dThisChannelNumber.isNaN() && dOtherChannelNumber.isNaN()) {
                return 0;
            }
            if (dThisChannelNumber.isNaN()) {
                return -1;
            }
            if (dOtherChannelNumber.isNaN()) {
                return 1;
            }
            if (dThisChannelNumber < dOtherChannelNumber) {
                return -1;
            }
            if (dThisChannelNumber > dOtherChannelNumber) {
                return 1;
            }
        }
        catch (Exception e) {
            LOGGER.fine("Error comparing channels: " + e.getMessage());
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Channel [");
        builder.append("channelId=");
        builder.append(this.channelId);
        builder.append(", ");
        if (this.channelNumber != null) {
            builder.append("channelNumber=");
            builder.append(this.channelNumber);
            builder.append(", ");
        }
        if (this.callSign != null) {
            builder.append("callSign=");
            builder.append(this.callSign);
            builder.append(", ");
        }
        if (this.iconUrl != null) {
            builder.append("iconUrl=");
            builder.append(this.iconUrl);
            builder.append(", ");
        }
        if (this.channelName != null) {
            builder.append("channelName=");
            builder.append(this.channelName);
            builder.append(", ");
        }
        builder.append("multiplexId=");
        builder.append(this.multiplexId);
        builder.append(", transportId=");
        builder.append(this.transportId);
        builder.append(", serviceId=");
        builder.append(this.serviceId);
        builder.append(", networkId=");
        builder.append(this.networkId);
        builder.append(", atscMajorChannel=");
        builder.append(this.atscMajorChannel);
        builder.append(", atscMinorChannel=");
        builder.append(this.atscMinorChannel);
        builder.append(", ");
        if (this.format != null) {
            builder.append("format=");
            builder.append(this.format);
            builder.append(", ");
        }
        if (this.modulation != null) {
            builder.append("modulation=");
            builder.append(this.modulation);
            builder.append(", ");
        }
        builder.append("frequency=");
        builder.append(this.frequency);
        builder.append(", ");
        if (this.frequencyId != null) {
            builder.append("frequencyId=");
            builder.append(this.frequencyId);
            builder.append(", ");
        }
        if (this.frequenceTable != null) {
            builder.append("frequenceTable=");
            builder.append(this.frequenceTable);
            builder.append(", ");
        }
        builder.append("fineTune=");
        builder.append(this.fineTune);
        builder.append(", ");
        if (this.siStandard != null) {
            builder.append("siStandard=");
            builder.append(this.siStandard);
            builder.append(", ");
        }
        if (this.channelFilters != null) {
            builder.append("channelFilters=");
            builder.append(this.channelFilters);
            builder.append(", ");
        }
        builder.append("sourceId=");
        builder.append(this.sourceId);
        builder.append(", inputId=");
        builder.append(this.inputId);
        builder.append(", commercialFree=");
        builder.append(this.commercialFree);
        builder.append(", useEit=");
        builder.append(this.useEit);
        builder.append(", visable=");
        builder.append(this.visable);
        builder.append(", ");
        if (this.xmltvId != null) {
            builder.append("xmltvId=");
            builder.append(this.xmltvId);
            builder.append(", ");
        }
        if (this.defaultAuth != null) {
            builder.append("defaultAuth=");
            builder.append(this.defaultAuth);
            builder.append(", ");
        }
        if (this.programs != null) {
            builder.append("programs=");
            builder.append(this.programs);
        }
        builder.append("]");
        return builder.toString();
    }
}

