/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026.status.beans;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.mythtv.services.api.DateTimeSerializer;
import org.mythtv.services.api.v026.status.beans.ArtworkInfos;
import org.mythtv.services.api.v026.status.beans.ChannelInfo;
import org.mythtv.services.api.v026.status.beans.Recording;
import org.mythtv.services.utils.ArticleCleaner;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="Program")
public class Program
implements Serializable,
Comparable<Program> {
    private static final long serialVersionUID = 4144422404144517653L;
    @JsonProperty(value="StartTime")
    @JsonSerialize(using=DateTimeSerializer.class)
    @Attribute
    private DateTime startTime;
    @JsonProperty(value="EndTime")
    @JsonSerialize(using=DateTimeSerializer.class)
    @Attribute
    private DateTime endTime;
    @JsonProperty(value="Title")
    @Attribute
    private String title;
    @JsonProperty(value="SubTitle")
    @Attribute
    private String subTitle;
    @JsonProperty(value="Category")
    @Attribute
    private String category;
    @JsonProperty(value="CatType")
    @Attribute(name="catType")
    private String categoryType;
    @JsonProperty(value="Repeat")
    @Attribute
    private boolean repeat;
    @JsonProperty(value="VideoProps")
    private int videoProps;
    @JsonProperty(value="AudioProps")
    private int audioProps;
    @JsonProperty(value="SubProps")
    private int subProps;
    @JsonProperty(value="SeriesId")
    @Attribute
    private String seriesId;
    @JsonProperty(value="ProgramId")
    @Attribute
    private String programId;
    @JsonProperty(value="Stars")
    @Attribute(name="stars", required=false)
    private float stars;
    @JsonProperty(value="FileSize")
    @Attribute(name="fileSize", required=false)
    private String fileSize;
    @JsonProperty(value="LastModified")
    @JsonSerialize(using=DateTimeSerializer.class)
    @Attribute
    private DateTime lastModified;
    @JsonProperty(value="ProgramFlags")
    @Attribute(name="programFlags")
    private String programFlags;
    @JsonProperty(value="HostName")
    @Attribute
    private String hostname;
    @JsonProperty(value="FileName")
    @Attribute(required=false)
    private String filename;
    @JsonProperty(value="Airdate")
    @JsonSerialize(using=DateTimeSerializer.class)
    @Attribute(name="airdate", required=false)
    private DateTime airDate;
    @JsonProperty(value="Description")
    private String description;
    @JsonProperty(value="Inetref")
    @Attribute(required=false)
    private String inetref;
    @JsonProperty(value="Season")
    @Attribute(required=false)
    private String season;
    @JsonProperty(value="Episode")
    @Attribute(required=false)
    private String episode;
    @JsonProperty(value="Channel")
    @Element(name="Channel", required=false)
    private ChannelInfo channelInfo;
    @JsonProperty(value="Recording")
    @Element(name="Recording", required=false)
    private Recording recording;
    @JsonProperty(value="Artwork")
    @Element(name="Artwork", required=false)
    private ArtworkInfos artwork;

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime startTime) {
        this.startTime = startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime endTime) {
        this.endTime = endTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryType() {
        return this.categoryType;
    }

    public void setCategoryType(String categoryType) {
        this.categoryType = categoryType;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public int getVideoProps() {
        return this.videoProps;
    }

    public void setVideoProps(int videoProps) {
        this.videoProps = videoProps;
    }

    public int getAudioProps() {
        return this.audioProps;
    }

    public void setAudioProps(int audioProps) {
        this.audioProps = audioProps;
    }

    public int getSubProps() {
        return this.subProps;
    }

    public void setSubProps(int subProps) {
        this.subProps = subProps;
    }

    public String getSeriesId() {
        return this.seriesId;
    }

    public void setSeriesId(String seriesId) {
        this.seriesId = seriesId;
    }

    public String getProgramId() {
        return this.programId;
    }

    public void setProgramId(String programId) {
        this.programId = programId;
    }

    public float getStars() {
        return this.stars;
    }

    public void setStars(float stars) {
        this.stars = stars;
    }

    public String getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(String fileSize) {
        this.fileSize = fileSize;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(DateTime lastModified) {
        this.lastModified = lastModified;
    }

    public String getProgramFlags() {
        return this.programFlags;
    }

    public void setProgramFlags(String programFlags) {
        this.programFlags = programFlags;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DateTime getAirDate() {
        return this.airDate;
    }

    public void setAirDate(DateTime airDate) {
        this.airDate = airDate;
    }

    public String getInetref() {
        return this.inetref;
    }

    public void setInetref(String inetref) {
        this.inetref = inetref;
    }

    public String getSeason() {
        return this.season;
    }

    public void setSeason(String season) {
        this.season = season;
    }

    public String getEpisode() {
        return this.episode;
    }

    public void setEpisode(String episode) {
        this.episode = episode;
    }

    public ChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public void setChannelInfo(ChannelInfo channelInfo) {
        this.channelInfo = channelInfo;
    }

    public Recording getRecording() {
        return this.recording;
    }

    public void setRecording(Recording recording) {
        this.recording = recording;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArtworkInfos getArtwork() {
        return this.artwork;
    }

    public void setArtwork(ArtworkInfos artwork) {
        this.artwork = artwork;
    }

    @JsonIgnore
    public long getDurationInMinutes() {
        if (null == this.startTime) {
            return 0L;
        }
        if (null == this.endTime) {
            return 0L;
        }
        return this.endTime.getMillis() / 60000L - this.startTime.getMillis() / 60000L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Program other = (Program)obj;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Program [");
        if (this.startTime != null) {
            builder.append("startTime=");
            builder.append(this.startTime);
            builder.append(", ");
        }
        if (this.endTime != null) {
            builder.append("endTime=");
            builder.append(this.endTime);
            builder.append(", ");
        }
        if (this.title != null) {
            builder.append("title=");
            builder.append(this.title);
            builder.append(", ");
        }
        if (this.subTitle != null) {
            builder.append("subTitle=");
            builder.append(this.subTitle);
            builder.append(", ");
        }
        if (this.category != null) {
            builder.append("category=");
            builder.append(this.category);
            builder.append(", ");
        }
        if (this.categoryType != null) {
            builder.append("categoryType=");
            builder.append(this.categoryType);
            builder.append(", ");
        }
        builder.append("repeat=");
        builder.append(this.repeat);
        builder.append(", ");
        builder.append("videoProps=");
        builder.append(this.videoProps);
        builder.append(", ");
        builder.append("audioProps=");
        builder.append(this.audioProps);
        builder.append(", ");
        builder.append("subProps=");
        builder.append(this.subProps);
        builder.append(", ");
        if (this.seriesId != null) {
            builder.append("seriesId=");
            builder.append(this.seriesId);
            builder.append(", ");
        }
        if (this.programId != null) {
            builder.append("programId=");
            builder.append(this.programId);
            builder.append(", ");
        }
        builder.append("stars=");
        builder.append(this.stars);
        builder.append(", ");
        if (this.fileSize != null) {
            builder.append("fileSize=");
            builder.append(this.fileSize);
            builder.append(", ");
        }
        if (this.lastModified != null) {
            builder.append("lastModified=");
            builder.append(this.lastModified);
            builder.append(", ");
        }
        if (this.programFlags != null) {
            builder.append("programFlags=");
            builder.append(this.programFlags);
            builder.append(", ");
        }
        if (this.hostname != null) {
            builder.append("hostname=");
            builder.append(this.hostname);
            builder.append(", ");
        }
        if (this.filename != null) {
            builder.append("filename=");
            builder.append(this.filename);
            builder.append(", ");
        }
        if (this.airDate != null) {
            builder.append("airDate=");
            builder.append(this.airDate);
            builder.append(", ");
        }
        if (this.description != null) {
            builder.append("description=");
            builder.append(this.description);
            builder.append(", ");
        }
        if (this.inetref != null) {
            builder.append("inetref=");
            builder.append(this.inetref);
            builder.append(", ");
        }
        if (this.season != null) {
            builder.append("season=");
            builder.append(this.season);
            builder.append(", ");
        }
        if (this.episode != null) {
            builder.append("episode=");
            builder.append(this.episode);
            builder.append(", ");
        }
        if (this.channelInfo != null) {
            builder.append("channelInfo=");
            builder.append(this.channelInfo);
            builder.append(", ");
        }
        if (this.recording != null) {
            builder.append("recording=");
            builder.append(this.recording);
            builder.append(", ");
        }
        if (this.artwork != null) {
            builder.append("artwork=");
            builder.append(this.artwork);
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(Program arg) {
        if (arg == null) {
            return 1;
        }
        if (this.title == null && arg.getTitle() == null) {
            return 0;
        }
        if (this.title == null) {
            return -1;
        }
        if (arg.getTitle() == null) {
            return 1;
        }
        String sThisTitle = ArticleCleaner.clean(this.title);
        String sOtherTitle = ArticleCleaner.clean(arg.getTitle());
        return sThisTitle.compareTo(sOtherTitle);
    }
}

