/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026.impl;

import org.mythtv.services.api.AbstractOperations;
import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v026.VideoOperations;
import org.mythtv.services.api.v026.beans.BlurayInfo;
import org.mythtv.services.api.v026.beans.VideoLookupList;
import org.mythtv.services.api.v026.beans.VideoMetadataInfo;
import org.mythtv.services.api.v026.beans.VideoMetadataInfoList;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class VideoTemplate
extends AbstractOperations
implements VideoOperations {
    private final RestOperations restOperations;

    public VideoTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase + "Video/");
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Bool> addVideo(String fileName, String hostName) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (fileName != null && !fileName.isEmpty()) {
            parameters.add((Object)"FileName", (Object)fileName);
        }
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddVideo", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<BlurayInfo> getBluray(String path, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (path != null && !path.isEmpty()) {
            parameters.add((Object)"Path", (Object)path);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetBluray", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), BlurayInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetadataInfo> getVideo(Integer id, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), VideoMetadataInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetadataInfo> getVideoByFileName(String fileName, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (fileName != null && !fileName.isEmpty()) {
            parameters.add((Object)"FileName", (Object)fileName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideoByFileName", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), VideoMetadataInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetadataInfoList> getVideoList(Boolean descending, Integer startIndex, Integer count, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (descending != null) {
            parameters.add((Object)"Descending", (Object)descending.toString());
        }
        if (startIndex != null) {
            parameters.add((Object)"StartIndex", (Object)startIndex.toString());
        }
        if (count != null) {
            parameters.add((Object)"Count", (Object)count.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideoList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), VideoMetadataInfoList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoLookupList> lookupVideo(String title, String subtitle, String inetref, Integer season, Integer episode, String grabberType, Boolean allowGeneric, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (title != null && !title.isEmpty()) {
            parameters.add((Object)"Title", (Object)title);
        }
        if (subtitle != null && !subtitle.isEmpty()) {
            parameters.add((Object)"Subtitle", (Object)subtitle);
        }
        if (inetref != null && !inetref.isEmpty()) {
            parameters.add((Object)"Inetref", (Object)inetref);
        }
        if (season != null) {
            parameters.add((Object)"Season", (Object)season.toString());
        }
        if (episode != null) {
            parameters.add((Object)"Episode", (Object)episode.toString());
        }
        if (grabberType != null && !grabberType.isEmpty()) {
            parameters.add((Object)"GrabberType", (Object)grabberType);
        }
        if (allowGeneric != null) {
            parameters.add((Object)"AllowGeneric", (Object)allowGeneric.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("LookupVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), VideoLookupList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeVideoFromDB(Integer id) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveVideoFromDB", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }
}

