/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.AbstractOperations;
import org.mythtv.services.api.ArrayOfString;
import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v026.FrontendOperations;
import org.mythtv.services.api.v026.beans.FrontendActionList;
import org.mythtv.services.api.v026.beans.FrontendStatus;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class FrontendTemplate
extends AbstractOperations
implements FrontendOperations {
    private final RestOperations restOperations;

    public FrontendTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase + "Frontend/");
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<FrontendActionList> getActionList(String context, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (context != null && !context.isEmpty()) {
            parameters.add((Object)"Context", (Object)context);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetActionList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), FrontendActionList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArrayOfString> getContextList(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetContextList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ArrayOfString.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<FrontendStatus> getStatus(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetStatus", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), FrontendStatus.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> playRecording(Integer chanId, DateTime startTime, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (chanId != null) {
            parameters.add((Object)"ChanId", (Object)chanId.toString());
        }
        if (startTime != null) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("PlayRecording", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> playVideo(String id, Boolean useBookmark, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null && !id.isEmpty()) {
            parameters.add((Object)"Id", (Object)id);
        }
        if (useBookmark != null) {
            parameters.add((Object)"UseBookmark", (Object)useBookmark.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("PlayVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> sendAction(String action, String value, Integer width, Integer height, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (action != null && !action.isEmpty()) {
            parameters.add((Object)"Action", (Object)action);
        }
        if (value != null && !value.isEmpty()) {
            parameters.add((Object)"Value", (Object)value);
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("SendAction", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> sendMessage(String message, Integer timeout, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (message != null && !message.isEmpty()) {
            parameters.add((Object)"Message", (Object)message);
        }
        if (timeout != null) {
            parameters.add((Object)"Timeout", (Object)timeout.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("SendMessage", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> sendNotification(Boolean error, String type, String message, String origin, String description, String image, String extra, String progressText, Float progress, Integer timeout, Boolean fullscreen, Integer visibility, Integer priority, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (error != null) {
            parameters.add((Object)"Error", (Object)error.toString());
        }
        if (type != null && !type.isEmpty()) {
            parameters.add((Object)"Type", (Object)type);
        }
        if (message != null && !message.isEmpty()) {
            parameters.add((Object)"Message", (Object)message);
        }
        if (origin != null && !origin.isEmpty()) {
            parameters.add((Object)"Origin", (Object)origin);
        }
        if (description != null && !description.isEmpty()) {
            parameters.add((Object)"Description", (Object)description);
        }
        if (image != null && !image.isEmpty()) {
            parameters.add((Object)"Image", (Object)image);
        }
        if (extra != null && !extra.isEmpty()) {
            parameters.add((Object)"Extra", (Object)extra);
        }
        if (progressText != null && !progressText.isEmpty()) {
            parameters.add((Object)"ProgressText", (Object)progressText);
        }
        if (progress != null) {
            parameters.add((Object)"Progress", (Object)progress.toString());
        }
        if (timeout != null) {
            parameters.add((Object)"Timeout", (Object)timeout.toString());
        }
        if (fullscreen != null) {
            parameters.add((Object)"Fullscreen", (Object)fullscreen.toString());
        }
        if (visibility != null) {
            parameters.add((Object)"Visibility", (Object)visibility.toString());
        }
        if (priority != null) {
            parameters.add((Object)"Priority", (Object)priority.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("SendNotification", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }
}

