/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026.impl;

import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v026.Bool;
import org.mythtv.services.api.v026.ChannelOperations;
import org.mythtv.services.api.v026.Int;
import org.mythtv.services.api.v026.StringList;
import org.mythtv.services.api.v026.beans.ChannelInfoList;
import org.mythtv.services.api.v026.beans.ChannelInfoWrapper;
import org.mythtv.services.api.v026.beans.LineupList;
import org.mythtv.services.api.v026.beans.VideoMultiplexList;
import org.mythtv.services.api.v026.beans.VideoMultiplexWrapper;
import org.mythtv.services.api.v026.beans.VideoSourceList;
import org.mythtv.services.api.v026.beans.VideoSourceWrapper;
import org.mythtv.services.api.v026.impl.AbstractChannelOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class ChannelTemplate
extends AbstractChannelOperations
implements ChannelOperations {
    private final RestOperations restOperations;

    public ChannelTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Bool> addDBChannel(int multiplexId, int sourceId, int channelId, String callSign, String channelName, String channelNumber, int serviceId, int atscMajorChannel, int atscMinorChannel, boolean userEIT, boolean visible, String frequencyId, String icon, String format, String xmltvId, String defaultAuthority) throws MythServiceApiRuntimeException {
        return null;
    }

    @Override
    public ResponseEntity<Int> addVideoSource(String sourceName, String grabber, String userId, String frequencyTable, String lineupId, String password, boolean useEit, String configPath, int nitId) throws MythServiceApiRuntimeException {
        return null;
    }

    @Override
    public ResponseEntity<Int> fetchChannelsFromSource(int sourceId, int cardId, boolean waitForFinish, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"SourceId", (Object)String.valueOf(sourceId));
        parameters.add((Object)"CardId", (Object)String.valueOf(cardId));
        parameters.add((Object)"WaitForFinish", (Object)Boolean.toString(waitForFinish));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.FETCH_CHANNELS_FROM_SOURCE.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), Int.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ChannelInfoWrapper> getChannelInfo(int channelId, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)String.valueOf(channelId));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_CHANNEL_INFO.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), ChannelInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ChannelInfoList> getChannelInfoList(int sourceId, int startIndex, int count, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (sourceId > 0) {
            parameters.add((Object)"SourceID", (Object)String.valueOf(sourceId));
        }
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)String.valueOf(startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)String.valueOf(count));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_CHANNEL_INFO_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), ChannelInfoList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ChannelInfoList> getChannelInfoList(ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_CHANNEL_INFO_LIST.getEndpoint()), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), ChannelInfoList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LineupList> getDDLineupList(String source, String userId, String password, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (source != null) {
            parameters.add((Object)"Source", (Object)source);
        }
        if (null != userId) {
            parameters.add((Object)"UserId", (Object)userId);
        }
        if (null != password) {
            parameters.add((Object)"Password", (Object)password);
        }
        ResponseEntity response = this.restOperations.exchange(this.buildUri(Endpoint.GET_DD_LINEUP_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), LineupList.class);
        this.handleResponseEtag(etag, response.getHeaders());
        return response;
    }

    @Override
    public ResponseEntity<VideoMultiplexWrapper> getVideoMultiplex(int multiplexId, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (multiplexId > 0) {
            parameters.add((Object)"MplexID", (Object)String.valueOf(multiplexId));
        }
        ResponseEntity response = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO_MULTIPLEX.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoMultiplexWrapper.class);
        this.handleResponseEtag(etag, response.getHeaders());
        return response;
    }

    @Override
    public ResponseEntity<VideoMultiplexList> getVideoMultiplexList(int sourceId, int startIndex, int count, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (sourceId > 0) {
            parameters.add((Object)"SourceID", (Object)String.valueOf(sourceId));
        }
        if (startIndex >= 0) {
            parameters.add((Object)"StartIndex", (Object)String.valueOf(startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)String.valueOf(count));
        }
        ResponseEntity response = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO_MULTIPLEX_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoMultiplexList.class);
        this.handleResponseEtag(etag, response.getHeaders());
        return response;
    }

    @Override
    public ResponseEntity<VideoSourceWrapper> getVideoSource(int sourceId, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (sourceId > 0) {
            parameters.add((Object)"SourceID", (Object)String.valueOf(sourceId));
        }
        ResponseEntity response = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO_SOURCE.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoSourceWrapper.class);
        this.handleResponseEtag(etag, response.getHeaders());
        return response;
    }

    @Override
    public ResponseEntity<VideoSourceList> getVideoSourceList(ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_VIDEO_SOURCE_LIST.getEndpoint()), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), VideoSourceList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<StringList> getXmltvIdList(int sourceId, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (sourceId > 0) {
            parameters.add((Object)"SourceID", (Object)String.valueOf(sourceId));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_XMLTVID_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag, new MediaType[0]), StringList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeDBChannel(int channelId) throws MythServiceApiRuntimeException {
        return null;
    }

    @Override
    public ResponseEntity<Bool> removeVideoSource(int sourceId) throws MythServiceApiRuntimeException {
        return null;
    }

    @Override
    public ResponseEntity<Bool> updateDBChannel(int multiplexId, int sourceId, int channelId, String callSign, String channelName, String channelNumber, int serviceId, int atscMajorChannel, int atscMinorChannel, boolean useEIT, boolean visible, String frequencyId, String icon, String format, String xmltvId, String defaultAuthority) throws MythServiceApiRuntimeException {
        return null;
    }

    @Override
    public ResponseEntity<Bool> updateVideoSource(int sourceId, String sourceName, String grabber, String userId, String frequencyTable, String lineupId, String password, boolean userEIT, String configPath, int nitId) throws MythServiceApiRuntimeException {
        return null;
    }

    public static enum Endpoint {
        ADD_DB_CHANNEL("AddDBChannel"),
        ADD_VIDEO_SOURCE("AddVideoSource"),
        FETCH_CHANNELS_FROM_SOURCE("FetchChannelsFromSource"),
        GET_CHANNEL_INFO("GetChannelInfo"),
        GET_CHANNEL_INFO_LIST("GetChannelInfoList"),
        GET_DD_LINEUP_LIST("GetDDLineupList"),
        GET_VIDEO_MULTIPLEX("GetVideoMultiplex"),
        GET_VIDEO_MULTIPLEX_LIST("GetVideoMultiplexList"),
        GET_VIDEO_SOURCE("GetVideoSource"),
        GET_VIDEO_SOURCE_LIST("GetVideoSourceList"),
        GET_XMLTVID_LIST("GetXMLTVIdList"),
        REMOVE_DB_CHANNEL("RemoveDBChannel"),
        REMOVE_VIDEO_SOURCE("RemoveVideoSource"),
        UPDATE_DB_CHANNEL("UpdateDBChannel"),
        UPDATE_VIDEO_SOURCE("UpdateVideoSource");

        private String endpoint;

        private Endpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

