/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v026;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.util.List;
import java.util.logging.Level;
import org.joda.time.DateTime;
import org.mythtv.services.api.BaseMythServicesTemplate;
import org.mythtv.services.api.MythServicesErrorHandler;
import org.mythtv.services.api.converters.JodaDateTimeTransform;
import org.mythtv.services.api.v026.CaptureOperations;
import org.mythtv.services.api.v026.ChannelOperations;
import org.mythtv.services.api.v026.ContentOperations;
import org.mythtv.services.api.v026.DvrOperations;
import org.mythtv.services.api.v026.FrontendOperations;
import org.mythtv.services.api.v026.GuideOperations;
import org.mythtv.services.api.v026.MythOperations;
import org.mythtv.services.api.v026.MythServices;
import org.mythtv.services.api.v026.StatusOperations;
import org.mythtv.services.api.v026.VideoOperations;
import org.mythtv.services.api.v026.beans.Job;
import org.mythtv.services.api.v026.impl.CaptureTemplate;
import org.mythtv.services.api.v026.impl.ChannelTemplate;
import org.mythtv.services.api.v026.impl.ContentTemplate;
import org.mythtv.services.api.v026.impl.DvrTemplate;
import org.mythtv.services.api.v026.impl.FrontendTemplate;
import org.mythtv.services.api.v026.impl.GuideTemplate;
import org.mythtv.services.api.v026.impl.MythTemplate;
import org.mythtv.services.api.v026.impl.StatusTemplate;
import org.mythtv.services.api.v026.impl.VideoTemplate;
import org.mythtv.services.api.v026.status.converters.JobCommandTransform;
import org.mythtv.services.api.v026.status.converters.JobFlagTransform;
import org.mythtv.services.api.v026.status.converters.JobStatusTransform;
import org.mythtv.services.api.v026.status.converters.JobTypeTransform;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.transform.Matcher;
import org.simpleframework.xml.transform.RegistryMatcher;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.SimpleXmlHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class MythServicesTemplate
extends BaseMythServicesTemplate
implements MythServices {
    private CaptureOperations captureOperations;
    private ChannelOperations channelOperations;
    private ContentOperations contentOperations;
    private DvrOperations dvrOperations;
    private FrontendOperations frontendOperations;
    private GuideOperations guideOperations;
    private MythOperations mythOperations;
    private StatusOperations statusOperations;
    private VideoOperations videoOperations;
    protected final RestOperations restOperations = this.createRestOperations();

    public MythServicesTemplate(String apiUrlBase) {
        this(apiUrlBase, Level.INFO);
    }

    public MythServicesTemplate(String apiUrlBase, Level logLevel) {
        super(apiUrlBase, logLevel);
        this.initSubApis();
    }

    protected RestOperations createRestOperations() {
        RestTemplate rest = new RestTemplate(true);
        this.initMessageConverters(rest.getMessageConverters());
        rest.setErrorHandler((ResponseErrorHandler)new MythServicesErrorHandler());
        return rest;
    }

    protected void initMessageConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<?> messageConverter : converters) {
            if (messageConverter instanceof MappingJackson2HttpMessageConverter) {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.registerModule((Module)new JodaModule());
                MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter = (MappingJackson2HttpMessageConverter)messageConverter;
                mappingJackson2HttpMessageConverter.setObjectMapper(objectMapper);
            }
            if (!(messageConverter instanceof SimpleXmlHttpMessageConverter)) continue;
            RegistryMatcher matchers = new RegistryMatcher();
            matchers.bind(DateTime.class, JodaDateTimeTransform.class);
            matchers.bind(Job.Command.class, JobCommandTransform.class);
            matchers.bind(Job.Flag.class, JobFlagTransform.class);
            matchers.bind(Job.Status.class, JobStatusTransform.class);
            matchers.bind(Job.Type.class, JobTypeTransform.class);
            AnnotationStrategy strategy = new AnnotationStrategy();
            Persister serializer = new Persister((Strategy)strategy, (Matcher)matchers);
            SimpleXmlHttpMessageConverter simpleXmlHttpMessageConverter = (SimpleXmlHttpMessageConverter)messageConverter;
            simpleXmlHttpMessageConverter.setSerializer((Serializer)serializer);
        }
    }

    @Override
    public CaptureOperations captureOperations() {
        return this.captureOperations;
    }

    @Override
    public ChannelOperations channelOperations() {
        return this.channelOperations;
    }

    @Override
    public ContentOperations contentOperations() {
        return this.contentOperations;
    }

    @Override
    public DvrOperations dvrOperations() {
        return this.dvrOperations;
    }

    @Override
    public FrontendOperations frontendOperations() {
        return this.frontendOperations;
    }

    @Override
    public GuideOperations guideOperations() {
        return this.guideOperations;
    }

    @Override
    public MythOperations mythOperations() {
        return this.mythOperations;
    }

    @Override
    public StatusOperations statusOperations() {
        return this.statusOperations;
    }

    @Override
    public VideoOperations videoOperations() {
        return this.videoOperations;
    }

    private RestOperations getRestOperations() {
        return this.restOperations;
    }

    private void initSubApis() {
        this.captureOperations = new CaptureTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.channelOperations = new ChannelTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.contentOperations = new ContentTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.dvrOperations = new DvrTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.frontendOperations = new FrontendTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.guideOperations = new GuideTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.mythOperations = new MythTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.statusOperations = new StatusTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.videoOperations = new VideoTemplate(this.getRestOperations(), this.getApiUrlBase());
    }
}

