/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v025.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.AbstractOperations;
import org.mythtv.services.api.ArrayOfString;
import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v025.MythOperations;
import org.mythtv.services.api.v025.beans.ConnectionInfo;
import org.mythtv.services.api.v025.beans.LogMessageList;
import org.mythtv.services.api.v025.beans.SettingList;
import org.mythtv.services.api.v025.beans.StorageGroupDirList;
import org.mythtv.services.api.v025.beans.TimeZoneInfo;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class MythTemplate
extends AbstractOperations
implements MythOperations {
    private final RestOperations restOperations;

    public MythTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase + "Myth/");
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Bool> addStorageGroupDir(String groupName, String dirName, String hostName) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (groupName != null && !groupName.isEmpty()) {
            parameters.add((Object)"GroupName", (Object)groupName);
        }
        if (dirName != null && !dirName.isEmpty()) {
            parameters.add((Object)"DirName", (Object)dirName);
        }
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddStorageGroupDir", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> backupDatabase() throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("BackupDatabase", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> changePassword(String userName, String oldPassword, String newPassword) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (userName != null && !userName.isEmpty()) {
            parameters.add((Object)"UserName", (Object)userName);
        }
        if (oldPassword != null && !oldPassword.isEmpty()) {
            parameters.add((Object)"OldPassword", (Object)oldPassword);
        }
        if (newPassword != null && !newPassword.isEmpty()) {
            parameters.add((Object)"NewPassword", (Object)newPassword);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("ChangePassword", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> checkDatabase(Boolean repair) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (repair != null) {
            parameters.add((Object)"Repair", (Object)repair.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("CheckDatabase", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<ConnectionInfo> getConnectionInfo(String pin, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (pin != null && !pin.isEmpty()) {
            parameters.add((Object)"Pin", (Object)pin);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetConnectionInfo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ConnectionInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getHostName(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetHostName", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArrayOfString> getHosts(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetHosts", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ArrayOfString.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArrayOfString> getKeys(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetKeys", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ArrayOfString.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LogMessageList> getLogs(String hostName, String application, Integer pID, Integer tID, String thread, String filename, Integer line, String function, DateTime fromTime, DateTime toTime, String level, String msgContains, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (application != null && !application.isEmpty()) {
            parameters.add((Object)"Application", (Object)application);
        }
        if (pID != null) {
            parameters.add((Object)"PID", (Object)pID.toString());
        }
        if (tID != null) {
            parameters.add((Object)"TID", (Object)tID.toString());
        }
        if (thread != null && !thread.isEmpty()) {
            parameters.add((Object)"Thread", (Object)thread);
        }
        if (filename != null && !filename.isEmpty()) {
            parameters.add((Object)"Filename", (Object)filename);
        }
        if (line != null) {
            parameters.add((Object)"Line", (Object)line.toString());
        }
        if (function != null && !function.isEmpty()) {
            parameters.add((Object)"Function", (Object)function);
        }
        if (fromTime != null) {
            parameters.add((Object)"FromTime", (Object)this.convertUtcAndFormat(fromTime));
        }
        if (toTime != null) {
            parameters.add((Object)"ToTime", (Object)this.convertUtcAndFormat(toTime));
        }
        if (level != null && !level.isEmpty()) {
            parameters.add((Object)"Level", (Object)level);
        }
        if (msgContains != null && !msgContains.isEmpty()) {
            parameters.add((Object)"MsgContains", (Object)msgContains);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetLogs", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LogMessageList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<SettingList> getSetting(String hostName, String key, String defaultValue, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (key != null && !key.isEmpty()) {
            parameters.add((Object)"Key", (Object)key);
        }
        if (defaultValue != null && !defaultValue.isEmpty()) {
            parameters.add((Object)"Default", (Object)defaultValue);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetSetting", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), SettingList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<StorageGroupDirList> getStorageGroupDirs(String groupName, String hostName, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (groupName != null && !groupName.isEmpty()) {
            parameters.add((Object)"GroupName", (Object)groupName);
        }
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetStorageGroupDirs", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), StorageGroupDirList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<TimeZoneInfo> getTimeZone(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetTimeZone", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), TimeZoneInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> profileDelete() throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("ProfileDelete", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> profileSubmit() throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("ProfileSubmit", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> profileText(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("ProfileText", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> profileURL(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("ProfileURL", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> profileUpdated(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("ProfileUpdated", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> putSetting(String hostName, String key, String value) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (key != null && !key.isEmpty()) {
            parameters.add((Object)"Key", (Object)key);
        }
        if (value != null && !value.isEmpty()) {
            parameters.add((Object)"Value", (Object)value);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("PutSetting", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeStorageGroupDir(String groupName, String dirName, String hostName) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (groupName != null && !groupName.isEmpty()) {
            parameters.add((Object)"GroupName", (Object)groupName);
        }
        if (dirName != null && !dirName.isEmpty()) {
            parameters.add((Object)"DirName", (Object)dirName);
        }
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveStorageGroupDir", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> sendMessage(String message, String address, Integer udpPort, Integer timeout, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (message != null && !message.isEmpty()) {
            parameters.add((Object)"Message", (Object)message);
        }
        if (address != null && !address.isEmpty()) {
            parameters.add((Object)"Address", (Object)address);
        }
        if (udpPort != null) {
            parameters.add((Object)"udpPort", (Object)udpPort.toString());
        }
        if (timeout != null) {
            parameters.add((Object)"Timeout", (Object)timeout.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("SendMessage", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> testDBSettings(String hostName, String userName, String password, String dBName, Integer dbPort) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (userName != null && !userName.isEmpty()) {
            parameters.add((Object)"UserName", (Object)userName);
        }
        if (password != null && !password.isEmpty()) {
            parameters.add((Object)"Password", (Object)password);
        }
        if (dBName != null && !dBName.isEmpty()) {
            parameters.add((Object)"DBName", (Object)dBName);
        }
        if (dbPort != null) {
            parameters.add((Object)"dbPort", (Object)dbPort.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("TestDBSettings", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }
}

