/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.v025.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.AbstractOperations;
import org.mythtv.services.api.ArrayOfString;
import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v025.ContentOperations;
import org.mythtv.services.api.v025.beans.ArtworkInfoList;
import org.mythtv.services.api.v025.beans.LiveStreamInfo;
import org.mythtv.services.api.v025.beans.LiveStreamInfoList;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class ContentTemplate
extends AbstractOperations
implements ContentOperations {
    private final RestOperations restOperations;

    public ContentTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase + "Content/");
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<LiveStreamInfo> addLiveStream(String storageGroup, String fileName, String hostName, Integer maxSegments, Integer width, Integer height, Integer bitrate, Integer audioBitrate, Integer sampleRate, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (storageGroup != null && !storageGroup.isEmpty()) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        if (fileName != null && !fileName.isEmpty()) {
            parameters.add((Object)"FileName", (Object)fileName);
        }
        if (hostName != null && !hostName.isEmpty()) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (maxSegments != null) {
            parameters.add((Object)"MaxSegments", (Object)maxSegments.toString());
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        if (bitrate != null) {
            parameters.add((Object)"Bitrate", (Object)bitrate.toString());
        }
        if (audioBitrate != null) {
            parameters.add((Object)"AudioBitrate", (Object)audioBitrate.toString());
        }
        if (sampleRate != null) {
            parameters.add((Object)"SampleRate", (Object)sampleRate.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LiveStreamInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfo> addRecordingLiveStream(Integer chanId, DateTime startTime, Integer maxSegments, Integer width, Integer height, Integer bitrate, Integer audioBitrate, Integer sampleRate, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (chanId != null) {
            parameters.add((Object)"ChanId", (Object)chanId.toString());
        }
        if (startTime != null) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        if (maxSegments != null) {
            parameters.add((Object)"MaxSegments", (Object)maxSegments.toString());
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        if (bitrate != null) {
            parameters.add((Object)"Bitrate", (Object)bitrate.toString());
        }
        if (audioBitrate != null) {
            parameters.add((Object)"AudioBitrate", (Object)audioBitrate.toString());
        }
        if (sampleRate != null) {
            parameters.add((Object)"SampleRate", (Object)sampleRate.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddRecordingLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LiveStreamInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfo> addVideoLiveStream(Integer id, Integer maxSegments, Integer width, Integer height, Integer bitrate, Integer audioBitrate, Integer sampleRate, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        if (maxSegments != null) {
            parameters.add((Object)"MaxSegments", (Object)maxSegments.toString());
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        if (bitrate != null) {
            parameters.add((Object)"Bitrate", (Object)bitrate.toString());
        }
        if (audioBitrate != null) {
            parameters.add((Object)"AudioBitrate", (Object)audioBitrate.toString());
        }
        if (sampleRate != null) {
            parameters.add((Object)"SampleRate", (Object)sampleRate.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddVideoLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LiveStreamInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> downloadFile(String uRL, String storageGroup) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (uRL != null && !uRL.isEmpty()) {
            parameters.add((Object)"URL", (Object)uRL);
        }
        if (storageGroup != null && !storageGroup.isEmpty()) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("DownloadFile", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null, new MediaType[0]), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getAlbumArt(Integer id, Integer width, Integer height, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetAlbumArt", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getFile(String storageGroup, String fileName, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (storageGroup != null && !storageGroup.isEmpty()) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        if (fileName != null && !fileName.isEmpty()) {
            parameters.add((Object)"FileName", (Object)fileName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetFile", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArrayOfString> getFileList(String storageGroup, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (storageGroup != null && !storageGroup.isEmpty()) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetFileList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ArrayOfString.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoList> getFilteredLiveStreamList(String fileName, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (fileName != null && !fileName.isEmpty()) {
            parameters.add((Object)"FileName", (Object)fileName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetFilteredLiveStreamList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LiveStreamInfoList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getHash(String storageGroup, String fileName, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (storageGroup != null && !storageGroup.isEmpty()) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        if (fileName != null && !fileName.isEmpty()) {
            parameters.add((Object)"FileName", (Object)fileName);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetHash", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getImageFile(String storageGroup, String fileName, Integer width, Integer height, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (storageGroup != null && !storageGroup.isEmpty()) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        if (fileName != null && !fileName.isEmpty()) {
            parameters.add((Object)"FileName", (Object)fileName);
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetImageFile", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfo> getLiveStream(Integer id, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LiveStreamInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoList> getLiveStreamList(ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetLiveStreamList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LiveStreamInfoList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getMusic(Integer id, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetMusic", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getPreviewImage(Integer chanId, DateTime startTime, Integer width, Integer height, Integer secsIn, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (chanId != null) {
            parameters.add((Object)"ChanId", (Object)chanId.toString());
        }
        if (startTime != null) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        if (secsIn != null) {
            parameters.add((Object)"SecsIn", (Object)secsIn.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetPreviewImage", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArtworkInfoList> getProgramArtworkList(String inetref, Integer season, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (inetref != null && !inetref.isEmpty()) {
            parameters.add((Object)"Inetref", (Object)inetref);
        }
        if (season != null) {
            parameters.add((Object)"Season", (Object)season.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetProgramArtworkList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ArtworkInfoList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getRecording(Integer chanId, DateTime startTime, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (chanId != null) {
            parameters.add((Object)"ChanId", (Object)chanId.toString());
        }
        if (startTime != null) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecording", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getRecordingArtwork(String type, String inetref, Integer season, Integer width, Integer height, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (type != null && !type.isEmpty()) {
            parameters.add((Object)"Type", (Object)type);
        }
        if (inetref != null && !inetref.isEmpty()) {
            parameters.add((Object)"Inetref", (Object)inetref);
        }
        if (season != null) {
            parameters.add((Object)"Season", (Object)season.toString());
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordingArtwork", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArtworkInfoList> getRecordingArtworkList(Integer chanId, DateTime startTime, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (chanId != null) {
            parameters.add((Object)"ChanId", (Object)chanId.toString());
        }
        if (startTime != null) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordingArtworkList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), ArtworkInfoList.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getVideo(Integer id, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getVideoArtwork(String type, Integer id, Integer width, Integer height, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (type != null && !type.isEmpty()) {
            parameters.add((Object)"Type", (Object)type);
        }
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        if (width != null) {
            parameters.add((Object)"Width", (Object)width.toString());
        }
        if (height != null) {
            parameters.add((Object)"Height", (Object)height.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideoArtwork", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), String.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeLiveStream(Integer id, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), Bool.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfo> stopLiveStream(Integer id, ETagInfo etagInfo) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (id != null) {
            parameters.add((Object)"Id", (Object)id.toString());
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("StopLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etagInfo, new MediaType[0]), LiveStreamInfo.class);
        this.handleResponseEtag(etagInfo, responseEntity.getHeaders());
        return responseEntity;
    }
}

