/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.converters.v25;

import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.simpleframework.xml.transform.Transform;

public class JodaDateTimeTransform
implements Transform<DateTime> {
    private static final String TAG = JodaDateTimeTransform.class.getSimpleName();
    private static final DateTimeFormatter isoFmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter dateFmt = DateTimeFormat.forPattern((String)"EEE MM dd yyyy");
    private static final DateTimeFormatter dateTimeShortFmt = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
    private final Logger logger = Logger.getLogger(TAG);

    public DateTime read(String value) throws Exception {
        try {
            return isoFmt.parseDateTime(value).withZoneRetainFields(DateTimeZone.UTC);
        }
        catch (Exception e) {
            try {
                return dateFmt.parseDateTime(value);
            }
            catch (Exception e2) {
                try {
                    return dateTimeShortFmt.parseDateTime(value);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    public String write(DateTime value) throws Exception {
        throw new UnsupportedOperationException("not implemented");
    }
}

