/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.connect;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.mythtv.services.api.ApiVersion;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.v025.MythServicesTemplate;
import org.mythtv.services.api.v027.MythServices;

public class MythAccessFactory {
    private static final String MYTHTV_SERVER_HEADER = "Server";
    private static final String MYTHTV_SERVER_MYTHVERSION = "MythTV ";

    public static <T> T getServiceTemplateApiByType(Class<T> serviceClass, String baseUri, Level logLevel) {
        if (serviceClass.isAssignableFrom(org.mythtv.services.api.v025.MythServices.class)) {
            return (T)new MythServicesTemplate(MythAccessFactory.scrubApiUrl(baseUri), logLevel);
        }
        if (serviceClass.isAssignableFrom(org.mythtv.services.api.v026.MythServices.class)) {
            return (T)new org.mythtv.services.api.v026.MythServicesTemplate(MythAccessFactory.scrubApiUrl(baseUri), logLevel);
        }
        if (serviceClass.isAssignableFrom(MythServices.class)) {
            return (T)new org.mythtv.services.api.v027.MythServicesTemplate(MythAccessFactory.scrubApiUrl(baseUri), logLevel);
        }
        return null;
    }

    public static <T> T getServiceTemplateApiByType(Class<T> serviceClass, String baseUri) {
        return MythAccessFactory.getServiceTemplateApiByType(serviceClass, baseUri, Level.INFO);
    }

    public static Object getServiceTemplateApiByVersion(ApiVersion version, String baseUri) {
        return MythAccessFactory.getServiceTemplateApiByVersion(version, baseUri, Level.INFO);
    }

    public static Object getServiceTemplateApiByVersion(ApiVersion version, String baseUri, Level logLevel) {
        if (version != null) {
            switch (version) {
                case v025: {
                    return new MythServicesTemplate(MythAccessFactory.scrubApiUrl(baseUri), logLevel);
                }
                case v026: {
                    return new org.mythtv.services.api.v026.MythServicesTemplate(MythAccessFactory.scrubApiUrl(baseUri), logLevel);
                }
                case v027: {
                    return new org.mythtv.services.api.v027.MythServicesTemplate(MythAccessFactory.scrubApiUrl(baseUri), logLevel);
                }
            }
        }
        return null;
    }

    public static ApiVersion getMythVersion(String baseUri) {
        try {
            URL url = new URL(baseUri + "Myth/GetHostName");
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("User-Agent", "Services API/Get MythTV Version");
            urlConnection.addRequestProperty("Connection", "Close");
            if (urlConnection.getResponseCode() == 200) {
                int idx;
                Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
                String server = urlConnection.getHeaderField(MYTHTV_SERVER_HEADER);
                byte[] drainResponse = new byte[64];
                BufferedInputStream bis = new BufferedInputStream(urlConnection.getInputStream());
                while (((InputStream)bis).read(drainResponse, 0, 64) > 0) {
                }
                urlConnection.disconnect();
                if (server != null && (idx = server.indexOf(MYTHTV_SERVER_MYTHVERSION)) >= 0) {
                    String version = server.substring(idx += MYTHTV_SERVER_MYTHVERSION.length());
                    if (version.startsWith("0.25")) {
                        return ApiVersion.v025;
                    }
                    if (version.startsWith("0.26")) {
                        return ApiVersion.v026;
                    }
                    if (version.startsWith("0.27")) {
                        return ApiVersion.v027;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MythServiceApiRuntimeException(e);
        }
        return ApiVersion.NotSupported;
    }

    public static boolean isServerReachable(String baseUrl) {
        boolean isOK = false;
        try {
            URL url = new URL(baseUrl.toString());
            HttpURLConnection urlcon = (HttpURLConnection)url.openConnection();
            urlcon.setRequestProperty("User-Agent", "Services API/Is Server Reachable");
            urlcon.addRequestProperty("Connection", "Close");
            isOK = urlcon.getResponseCode() == 200;
            byte[] drainResponse = new byte[64];
            BufferedInputStream bis = new BufferedInputStream(urlcon.getInputStream());
            while (((InputStream)bis).read(drainResponse, 0, 64) > 0) {
            }
            urlcon.disconnect();
        }
        catch (Exception e) {
            throw new MythServiceApiRuntimeException(e);
        }
        return isOK;
    }

    private static String scrubApiUrl(String apiUrlBase) {
        if (!apiUrlBase.endsWith("/")) {
            return apiUrlBase + "/";
        }
        return apiUrlBase;
    }
}

