/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.capture.impl;

import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.Int;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.capture.CaptureCard;
import org.mythtv.services.api.capture.CaptureCardList;
import org.mythtv.services.api.capture.CaptureCardWrapper;
import org.mythtv.services.api.capture.CaptureOperations;
import org.mythtv.services.api.capture.CardInput;
import org.mythtv.services.api.capture.impl.AbstractCaptureOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class CaptureTemplate
extends AbstractCaptureOperations
implements CaptureOperations {
    private final RestOperations restOperations;

    public CaptureTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Int> addCaptureCard(CaptureCard captureCard) throws MythServiceApiRuntimeException {
        return this.restOperations.exchange(this.buildUri(Endpoint.ADD_CAPTURE_CARD.getEndpoint(), (MultiValueMap<String, String>)this.convertCaptureCardToParameters(captureCard)), HttpMethod.GET, this.getRequestEntity(null), Int.class);
    }

    @Override
    public ResponseEntity<Int> addCardInput(CardInput cardInput) throws MythServiceApiRuntimeException {
        return this.restOperations.exchange(this.buildUri(Endpoint.ADD_CARD_INPUT.getEndpoint(), (MultiValueMap<String, String>)this.convertCardInputToParameters(cardInput)), HttpMethod.GET, this.getRequestEntity(null), Int.class);
    }

    @Override
    public ResponseEntity<CaptureCardWrapper> getCaptureCard(int cardId, ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_CAPTURE_CARD.getEndpoint(), "CardId", new String(String.valueOf(cardId))), HttpMethod.GET, this.getRequestEntity(etag), CaptureCardWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<CaptureCardList> getCaptureCardList(ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_CAPTURE_CARD_LIST.getEndpoint()), HttpMethod.GET, this.getRequestEntity(etag), CaptureCardList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<CaptureCardList> getCaptureCardList(String hostName, String cardType, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (null != hostName && !"".equals(hostName)) {
            parameters.add((Object)"HostName", (Object)hostName);
        }
        if (null != cardType && !"".equals(cardType)) {
            parameters.add((Object)"CardType", (Object)cardType);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.GET_CAPTURE_CARD_LIST.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), CaptureCardList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeCaptureCard(int cardId, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"CardId", (Object)new String(String.valueOf(cardId)));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri(Endpoint.REMOVE_CAPTURE_CARD.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), Bool.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeCardInput(int cardInputId) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"CardInputId", (Object)new String(String.valueOf(cardInputId)));
        return this.restOperations.exchange(this.buildUri(Endpoint.REMOVE_CARD_INPUT.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), Bool.class);
    }

    @Override
    public ResponseEntity<Bool> updateCaptureCard(int cardId, String setting, String value) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"CardId", (Object)new String(String.valueOf(cardId)));
        parameters.add((Object)setting, (Object)value);
        return this.restOperations.exchange(this.buildUri(Endpoint.UPDATE_CAPTURE_CARD.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), Bool.class);
    }

    @Override
    public ResponseEntity<Bool> updateCardInput(int cardInputId, String setting, String value) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"CardInputId", (Object)new String(String.valueOf(cardInputId)));
        parameters.add((Object)setting, (Object)value);
        return this.restOperations.exchange(this.buildUri(Endpoint.UPDATE_CARD_INPUT.getEndpoint(), (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), Bool.class);
    }

    private LinkedMultiValueMap<String, String> convertCaptureCardToParameters(CaptureCard captureCard) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"VideoDevice", (Object)captureCard.getVbiDevice());
        parameters.add((Object)"CardType", (Object)captureCard.getCardType());
        parameters.add((Object)"DefaultInput", (Object)"");
        parameters.add((Object)"HostName", (Object)captureCard.getHostName());
        parameters.add((Object)"AudioDevice", (Object)captureCard.getAudioDevice());
        parameters.add((Object)"VBIDevice", (Object)captureCard.getVbiDevice());
        parameters.add((Object)"AudioRateLimit", (Object)captureCard.getAudioRateLimit().toString());
        parameters.add((Object)"SkipBTAudio", (Object)captureCard.getSkipBtAudio().toString());
        parameters.add((Object)"DVBSWFilter", (Object)captureCard.getDvbSwFilter().toString());
        parameters.add((Object)"DVBSatType", (Object)captureCard.getDvbSatType().toString());
        parameters.add((Object)"DVBWaitForSeqStart", (Object)captureCard.getDvbWaitForSeqStart().toString());
        parameters.add((Object)"DVBOnDemand", (Object)captureCard.getDvbOnDemand().toString());
        parameters.add((Object)"DVBDiSEqCType", (Object)captureCard.getDvbDiSEqCType().toString());
        parameters.add((Object)"FirewireModel", (Object)captureCard.getFirewireModel());
        parameters.add((Object)"FirewireSpeed", (Object)captureCard.getFirewireSpeed().toString());
        parameters.add((Object)"FirewireConnection", (Object)captureCard.getFirewireConnection().toString());
        parameters.add((Object)"SignalTimeout", (Object)captureCard.getSignalTimeout().toString());
        parameters.add((Object)"ChannelTimeout", (Object)captureCard.getChannelTimeout().toString());
        parameters.add((Object)"DVBTuningDelay", (Object)captureCard.getDvbTuningDelay().toString());
        parameters.add((Object)"Contrast", (Object)captureCard.getContrast().toString());
        parameters.add((Object)"Brightness", (Object)captureCard.getBrightness().toString());
        parameters.add((Object)"Colour", (Object)captureCard.getColour().toString());
        parameters.add((Object)"Hue", (Object)captureCard.getHue().toString());
        parameters.add((Object)"DiSEqCId", (Object)captureCard.getDiSEqCId().toString());
        parameters.add((Object)"DVBEITScan", (Object)captureCard.getDvbEitScan().toString());
        return parameters;
    }

    private LinkedMultiValueMap<String, String> convertCardInputToParameters(CardInput cardInput) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"CardId", (Object)String.valueOf(cardInput.getCardId()));
        parameters.add((Object)"SourceId", (Object)String.valueOf(cardInput.getSourceId()));
        parameters.add((Object)"InputName", (Object)cardInput.getInputName());
        parameters.add((Object)"ExternalCommand", (Object)cardInput.getExternalCommand());
        parameters.add((Object)"ChangerDevice", (Object)cardInput.getChangerDevice());
        parameters.add((Object)"ChangerModel", (Object)cardInput.getChangerModel());
        parameters.add((Object)"HostName", (Object)cardInput.getHosthame());
        parameters.add((Object)"TuneChan", (Object)cardInput.getTuneChannel());
        parameters.add((Object)"StartChan", (Object)cardInput.getStartChannel());
        parameters.add((Object)"DisplayName", (Object)cardInput.getDisplayName());
        parameters.add((Object)"DishnetEIT", (Object)String.valueOf(cardInput.isDishnetEIT()));
        parameters.add((Object)"RecPriority", (Object)String.valueOf(cardInput.getRecordingPriority()));
        parameters.add((Object)"Quicktune", (Object)String.valueOf(cardInput.getQuicktune()));
        parameters.add((Object)"SchedOrder", (Object)String.valueOf(cardInput.getSchedOrder()));
        parameters.add((Object)"LiveTVOrder", (Object)String.valueOf(cardInput.getLiveTVOrder()));
        return parameters;
    }

    public static enum Endpoint {
        ADD_CAPTURE_CARD("AddCaptureCard"),
        ADD_CARD_INPUT("AddCardInput"),
        GET_CAPTURE_CARD("GetCaptureCard"),
        GET_CAPTURE_CARD_LIST("GetCaptureCardList"),
        REMOVE_CAPTURE_CARD("RemoveCaptureCard"),
        REMOVE_CARD_INPUT("RemoveCardInput"),
        UPDATE_CAPTURE_CARD("UpdateCaptureCard"),
        UPDATE_CARD_INPUT("UpdateCardInput");

        private String endpoint;

        private Endpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

