/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.guide.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.dvr.ProgramWrapper;
import org.mythtv.services.api.guide.GuideOperations;
import org.mythtv.services.api.guide.ProgramGuideWrapper;
import org.mythtv.services.api.guide.impl.AbstractGuideOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class GuideTemplate
extends AbstractGuideOperations
implements GuideOperations {
    private final RestOperations restOperations;

    public GuideTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<String> getChannelIcon(int channelId, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetChannelIcon", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), String.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramWrapper> getProgramDetails(int channelId, DateTime startTime, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        if (null != startTime) {
            parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetProgramDetails", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramGuideWrapper> getProgramGuide(DateTime start, DateTime end, int startChannelId, int numberOfChannels, boolean details, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(start));
        parameters.add((Object)"EndTime", (Object)this.convertUtcAndFormat(end));
        if (startChannelId > 0) {
            parameters.add((Object)"StartChanId", (Object)("" + startChannelId));
        }
        if (numberOfChannels > 0) {
            parameters.add((Object)"NumChannels", (Object)("" + numberOfChannels));
        }
        if (details) {
            parameters.add((Object)"Details", (Object)Boolean.toString(details));
        }
        try {
            ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetProgramGuide", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramGuideWrapper.class);
            this.handleResponseEtag(etag, responseEntity.getHeaders());
            return responseEntity;
        }
        catch (Exception e) {
            throw new MythServiceApiRuntimeException(e);
        }
    }
}

