/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.content.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.StringList;
import org.mythtv.services.api.content.ArtworkInfoList;
import org.mythtv.services.api.content.ArtworkInfos;
import org.mythtv.services.api.content.ContentOperations;
import org.mythtv.services.api.content.LiveStreamInfo;
import org.mythtv.services.api.content.LiveStreamInfoWrapper;
import org.mythtv.services.api.content.LiveStreamInfos;
import org.mythtv.services.api.content.impl.AbstractContentOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class ContentTemplate
extends AbstractContentOperations
implements ContentOperations {
    private final RestOperations restOperations;

    public ContentTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> addLiveStream(String storageGroup, String filename, String hostname, int maxSegments, int width, int height, int bitrate, int audioBitrate, int sampleRate) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)("" + filename));
        if (storageGroup != null) {
            parameters.add((Object)"StorageGroup", (Object)("" + storageGroup));
        }
        if (hostname != null) {
            parameters.add((Object)"HostName", (Object)("" + hostname));
        }
        if (maxSegments > 0) {
            parameters.add((Object)"MaxSegments", (Object)("" + maxSegments));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        if (bitrate > 0) {
            parameters.add((Object)"Bitrate", (Object)("" + bitrate));
        }
        if (audioBitrate > 0) {
            parameters.add((Object)"AudioBitrate", (Object)("" + audioBitrate));
        }
        if (sampleRate > 0) {
            parameters.add((Object)"SampleRate", (Object)("" + sampleRate));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), LiveStreamInfoWrapper.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> addRecordingLiveStream(int channelId, DateTime startTime, int maxSegments, int width, int height, int bitrate, int audioBitrate, int sampleRate) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        if (maxSegments > 0) {
            parameters.add((Object)"MaxSegments", (Object)("" + maxSegments));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        if (bitrate > 0) {
            parameters.add((Object)"Bitrate", (Object)("" + bitrate));
        }
        if (audioBitrate > 0) {
            parameters.add((Object)"AudioBitrate", (Object)("" + audioBitrate));
        }
        if (sampleRate > 0) {
            parameters.add((Object)"SampleRate", (Object)("" + sampleRate));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddRecordingLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), LiveStreamInfoWrapper.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> addVideoLiveStream(int id, int maxSegments, int width, int height, int bitrate, int audioBitrate, int sampleRate) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        if (maxSegments > 0) {
            parameters.add((Object)"MaxSegments", (Object)("" + maxSegments));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        if (bitrate > 0) {
            parameters.add((Object)"Bitrate", (Object)("" + bitrate));
        }
        if (audioBitrate > 0) {
            parameters.add((Object)"AudioBitrate", (Object)("" + audioBitrate));
        }
        if (sampleRate > 0) {
            parameters.add((Object)"SampleRate", (Object)("" + sampleRate));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddVideoLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), LiveStreamInfoWrapper.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> downloadFile(String url, String storageGroup, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        parameters.add((Object)"URL", (Object)url);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("DownloadFile", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), Bool.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getAlbumArt(int id, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetAlbumArt", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getFile(String storageGroup, String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        if (null != filename && !"".equals(filename)) {
            parameters.add((Object)"FileName", (Object)filename);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetFile", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<StringList> getFileList(String storageGroup, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetFileList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), StringList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfos> getFilteredLiveStreamList(String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)filename);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetFilteredLiveStreamList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), LiveStreamInfos.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<String> getHash(String storageGroup, String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        parameters.add((Object)"FileName", (Object)filename);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetHash", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), String.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getImageFile(String storageGroup, String filename, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        parameters.add((Object)"FileName", (Object)filename);
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetImageFile", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfoWrapper> getLiveStream(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetLiveStream", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), LiveStreamInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfos> getLiveStreamList(ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetLiveStreamList"), HttpMethod.GET, this.getRequestEntity(etag), LiveStreamInfos.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getMusic(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetMusic", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getPreviewImage(int channelId, DateTime startTime, int width, int height, int secondsIn, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        if (secondsIn > 0) {
            parameters.add((Object)"SecsIn", (Object)("" + secondsIn));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetPreviewImage", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArtworkInfos> getProgramArtworkList(String inetRef, int season, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Inetref", (Object)inetRef);
        if (season > 0) {
            parameters.add((Object)"Season", (Object)("" + season));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetProgramArtwork", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ArtworkInfos.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getRecording(int channelId, DateTime startTime, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecording", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getRecordingArtwork(String type, String inetRef, int season, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Inetref", (Object)inetRef);
        if (null != type && !"".equals(type)) {
            parameters.add((Object)"Type", (Object)type);
        }
        if (season > 0) {
            parameters.add((Object)"Season", (Object)("" + season));
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordingArtwork", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ArtworkInfoList> getRecordingArtworkList(int channelId, DateTime startTime, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordingArtworkList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ArtworkInfoList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getVideo(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<byte[]> getVideoArtwork(String type, int id, int width, int height, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        if (null != type && !"".equals(type)) {
            parameters.add((Object)"Type", (Object)type);
        }
        if (width > 0) {
            parameters.add((Object)"Width", (Object)("" + width));
        }
        if (height > 0) {
            parameters.add((Object)"Height", (Object)("" + height));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideoArtwork", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), byte[].class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeLiveStream(int id) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveLiveStream", "Id", "" + id), HttpMethod.GET, this.getRequestEntity(null), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<LiveStreamInfo> stopLiveStream(int id) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("StopLiveStream", "Id", "" + id), HttpMethod.GET, this.getRequestEntity(null), LiveStreamInfo.class);
        return responseEntity;
    }
}

