/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.video.impl;

import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.video.BlurayInfoWrapper;
import org.mythtv.services.api.video.VideoLookupList;
import org.mythtv.services.api.video.VideoMetaDataInfoWrapper;
import org.mythtv.services.api.video.VideoMetadataInfoList;
import org.mythtv.services.api.video.VideoOperations;
import org.mythtv.services.api.video.impl.AbstractVideoOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class VideoTemplate
extends AbstractVideoOperations
implements VideoOperations {
    private final RestOperations restOperations;

    public VideoTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Bool> addVideo(String filename, String hostname) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)filename);
        parameters.add((Object)"HostName", (Object)hostname);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<BlurayInfoWrapper> getBluray(String path, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Path", (Object)path);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetBluray", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), BlurayInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetaDataInfoWrapper> getVideo(int id, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), VideoMetaDataInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetaDataInfoWrapper> getVideoByFilename(String filename, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"FileName", (Object)filename);
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideoByFileName", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), VideoMetaDataInfoWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoMetadataInfoList> getVideoList(boolean descending, int startIndex, int count, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Descending", (Object)Boolean.toString(descending));
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)("" + startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)("" + count));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetVideoList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), VideoMetadataInfoList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<VideoLookupList> lookupVideo(String title, String subtitle, String inetRef, int season, int episode, String grabberType, boolean allowGeneric, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Title", (Object)title);
        if (null != subtitle && !"".equals(subtitle)) {
            parameters.add((Object)"Subtitle", (Object)subtitle);
        }
        if (null != inetRef && !"".equals(inetRef)) {
            parameters.add((Object)"Inetref", (Object)inetRef);
        }
        if (season > 0) {
            parameters.add((Object)"Season", (Object)("" + season));
        }
        if (episode > 0) {
            parameters.add((Object)"Episode", (Object)("" + episode));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("LookupVideo", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), VideoLookupList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeVideoFromDatabase(int id) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Id", (Object)("" + id));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveVideoFromDB", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), Bool.class);
        return responseEntity;
    }
}

