/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api.dvr.impl;

import org.joda.time.DateTime;
import org.mythtv.services.api.Bool;
import org.mythtv.services.api.ETagInfo;
import org.mythtv.services.api.Int;
import org.mythtv.services.api.MythServiceApiRuntimeException;
import org.mythtv.services.api.dvr.DvrOperations;
import org.mythtv.services.api.dvr.EncoderList;
import org.mythtv.services.api.dvr.ProgramList;
import org.mythtv.services.api.dvr.ProgramWrapper;
import org.mythtv.services.api.dvr.RecRuleList;
import org.mythtv.services.api.dvr.RecRuleWrapper;
import org.mythtv.services.api.dvr.impl.AbstractDvrOperations;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;

public class DvrTemplate
extends AbstractDvrOperations
implements DvrOperations {
    private final RestOperations restOperations;

    public DvrTemplate(RestOperations restOperations, String apiUrlBase) {
        super(apiUrlBase);
        this.restOperations = restOperations;
    }

    @Override
    public ResponseEntity<Int> addRecordingSchedule(int channelId, DateTime startTime, int parentId, boolean interactive, int season, int episode, String inetRef, int findId, String type, String searchType, int recordingPriority, int perferredInput, int startOffset, int endOffset, String duplicateMethod, String duplicateIn, int filter, String recordingProfile, String recordingGroup, String storageGroup, String playGroup, boolean autoExpire, int maxEpisodes, boolean maxNewest, boolean autoCommercialFlag, boolean autoTranscode, boolean autoMetadataLookup, boolean autoUserJob1, boolean autoUserJob2, boolean autoUserJob3, boolean autoUserJob4, int transcoder) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        parameters.add((Object)"ParentId", (Object)("" + parentId));
        parameters.add((Object)"Inactive", (Object)Boolean.toString(interactive));
        parameters.add((Object)"Season", (Object)("" + season));
        parameters.add((Object)"Episode", (Object)("" + episode));
        parameters.add((Object)"Inetref", (Object)inetRef);
        parameters.add((Object)"FindId", (Object)("" + findId));
        parameters.add((Object)"Type", (Object)type);
        parameters.add((Object)"SearchType", (Object)searchType);
        parameters.add((Object)"RecPriority", (Object)("" + recordingPriority));
        parameters.add((Object)"PreferredInput", (Object)("" + perferredInput));
        parameters.add((Object)"StartOffset", (Object)("" + startOffset));
        parameters.add((Object)"EndOffset", (Object)("" + endOffset));
        parameters.add((Object)"DupMethod", (Object)duplicateMethod);
        parameters.add((Object)"DupIn", (Object)duplicateIn);
        parameters.add((Object)"Filter", (Object)("" + filter));
        parameters.add((Object)"RecProfile", (Object)recordingProfile);
        parameters.add((Object)"RecGroup", (Object)recordingGroup);
        parameters.add((Object)"StorageGroup", (Object)storageGroup);
        parameters.add((Object)"PlayGroup", (Object)playGroup);
        parameters.add((Object)"AutoExpire", (Object)Boolean.toString(autoExpire));
        parameters.add((Object)"MaxEpisodes", (Object)("" + maxEpisodes));
        parameters.add((Object)"MaxNewest", (Object)Boolean.toString(maxNewest));
        parameters.add((Object)"AutoCommflag", (Object)Boolean.toString(autoCommercialFlag));
        parameters.add((Object)"AutoTranscode", (Object)Boolean.toString(autoTranscode));
        parameters.add((Object)"AutoMetaLookup", (Object)Boolean.toString(autoMetadataLookup));
        parameters.add((Object)"AutoUserJob1", (Object)Boolean.toString(autoUserJob1));
        parameters.add((Object)"AutoUserJob2", (Object)Boolean.toString(autoUserJob2));
        parameters.add((Object)"AutoUserJob3", (Object)Boolean.toString(autoUserJob3));
        parameters.add((Object)"AutoUserJob4", (Object)Boolean.toString(autoUserJob4));
        parameters.add((Object)"Transcoder", (Object)("" + transcoder));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("AddRecordSchedule", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null), Int.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> disableRecordingSchedule(int recordingId) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"RecordId", (Object)("" + recordingId));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("DisableRecordSchedule", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> enableRecordingSchedule(int recordingId) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"RecordId", (Object)("" + recordingId));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("EnableRecordSchedule", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramList> getConflictList(int startIndex, int count, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)("" + startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)("" + count));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetConflictList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<EncoderList> getEncoderList(ETagInfo etag) throws MythServiceApiRuntimeException {
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetConflictList"), HttpMethod.GET, this.getRequestEntity(etag), EncoderList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramList> getExpiringList(int startIndex, int count, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)("" + startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)("" + count));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetExpiringList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramList> getFiltererRecordedList(boolean descending, int startIndex, int count, String titleRegEx, String recordingGroup, String storageGroup, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"Descending", (Object)Boolean.toString(descending));
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)("" + startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)("" + count));
        }
        if (null != titleRegEx && !"".equals(titleRegEx)) {
            parameters.add((Object)"TitleRegEx", (Object)titleRegEx);
        }
        if (null != recordingGroup && !"".equals(recordingGroup)) {
            parameters.add((Object)"RecGroup", (Object)recordingGroup);
        }
        if (null != storageGroup && !"".equals(storageGroup)) {
            parameters.add((Object)"StorageGroup", (Object)storageGroup);
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetFilteredRecordedList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<RecRuleWrapper> getRecordSchedule(int recordId, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"RecordId", (Object)("" + recordId));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordSchedule", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), RecRuleWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<RecRuleList> getRecordScheduleList(int startIndex, int count, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)("" + startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)("" + count));
        }
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordScheduleList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), RecRuleList.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramWrapper> getRecorded(int channelId, DateTime startTime, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecorded", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramWrapper.class);
        this.handleResponseEtag(etag, responseEntity.getHeaders());
        return responseEntity;
    }

    @Override
    public ResponseEntity<ProgramList> getRecordedList(ETagInfo etag) throws MythServiceApiRuntimeException {
        try {
            ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordedList"), HttpMethod.GET, this.getRequestEntity(etag), ProgramList.class);
            this.handleResponseEtag(etag, responseEntity.getHeaders());
            return responseEntity;
        }
        catch (Exception e) {
            throw new MythServiceApiRuntimeException(e);
        }
    }

    @Override
    public ResponseEntity<ProgramList> getRecordedList(int startIndex, int count, boolean descending, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)("" + startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)("" + count));
        }
        parameters.add((Object)"Descending", (Object)Boolean.toString(descending));
        try {
            ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetRecordedList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramList.class);
            this.handleResponseEtag(etag, responseEntity.getHeaders());
            return responseEntity;
        }
        catch (Exception e) {
            throw new MythServiceApiRuntimeException(e);
        }
    }

    @Override
    public ResponseEntity<ProgramList> getUpcomingList(int startIndex, int count, boolean showAll, ETagInfo etag) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (startIndex > 0) {
            parameters.add((Object)"StartIndex", (Object)("" + startIndex));
        }
        if (count > 0) {
            parameters.add((Object)"Count", (Object)("" + count));
        }
        parameters.add((Object)"ShowAll", (Object)Boolean.toString(showAll));
        try {
            ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("GetUpcomingList", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(etag), ProgramList.class);
            this.handleResponseEtag(etag, responseEntity.getHeaders());
            return responseEntity;
        }
        catch (Exception e) {
            throw new MythServiceApiRuntimeException(e);
        }
    }

    @Override
    public ResponseEntity<Bool> removeRecordingSchedule(int recordingId) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"RecordId", (Object)("" + recordingId));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveRecordSchedule", (MultiValueMap<String, String>)parameters), HttpMethod.POST, this.getRequestEntity(null), Bool.class);
        return responseEntity;
    }

    @Override
    public ResponseEntity<Bool> removeRecorded(int channelId, DateTime startTime) throws MythServiceApiRuntimeException {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"ChanId", (Object)("" + channelId));
        parameters.add((Object)"StartTime", (Object)this.convertUtcAndFormat(startTime));
        ResponseEntity responseEntity = this.restOperations.exchange(this.buildUri("RemoveRecorded", (MultiValueMap<String, String>)parameters), HttpMethod.GET, this.getRequestEntity(null), Bool.class);
        return responseEntity;
    }
}

