/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api;

import org.mythtv.services.api.MythServices;
import org.mythtv.services.api.capture.CaptureOperations;
import org.mythtv.services.api.capture.impl.CaptureTemplate;
import org.mythtv.services.api.channel.ChannelOperations;
import org.mythtv.services.api.channel.impl.ChannelTemplate;
import org.mythtv.services.api.content.ContentOperations;
import org.mythtv.services.api.content.impl.ContentTemplate;
import org.mythtv.services.api.dvr.DvrOperations;
import org.mythtv.services.api.dvr.impl.DvrTemplate;
import org.mythtv.services.api.frontend.FrontendOperations;
import org.mythtv.services.api.frontend.impl.FrontendTemplate;
import org.mythtv.services.api.guide.GuideOperations;
import org.mythtv.services.api.guide.impl.GuideTemplate;
import org.mythtv.services.api.myth.MythOperations;
import org.mythtv.services.api.myth.impl.MythTemplate;
import org.mythtv.services.api.video.VideoOperations;
import org.mythtv.services.api.video.impl.VideoTemplate;
import org.springframework.web.client.RestOperations;

public abstract class BaseMythServicesTemplate
implements MythServices {
    private final String apiUrlBase;
    private final RestOperations restOperations;
    private CaptureOperations captureOperations;
    private ChannelOperations channelOperations;
    private ContentOperations contentOperations;
    private DvrOperations dvrOperations;
    private FrontendOperations frontendOperations;
    private GuideOperations guideOperations;
    private MythOperations mythOperations;
    private VideoOperations videoOperations;

    public BaseMythServicesTemplate(String apiUrlBase) {
        this.apiUrlBase = apiUrlBase;
        this.restOperations = this.createRestOperations();
        this.initSubApis();
    }

    @Override
    public CaptureOperations captureOperations() {
        return this.captureOperations;
    }

    @Override
    public ChannelOperations channelOperations() {
        return this.channelOperations;
    }

    @Override
    public ContentOperations contentOperations() {
        return this.contentOperations;
    }

    @Override
    public DvrOperations dvrOperations() {
        return this.dvrOperations;
    }

    @Override
    public FrontendOperations frontendOperations() {
        return this.frontendOperations;
    }

    @Override
    public GuideOperations guideOperations() {
        return this.guideOperations;
    }

    @Override
    public MythOperations mythOperations() {
        return this.mythOperations;
    }

    @Override
    public VideoOperations videoOperations() {
        return this.videoOperations;
    }

    protected abstract RestOperations createRestOperations();

    private String getApiUrlBase() {
        return this.apiUrlBase;
    }

    private RestOperations getRestOperations() {
        return this.restOperations;
    }

    private void initSubApis() {
        this.captureOperations = new CaptureTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.channelOperations = new ChannelTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.contentOperations = new ContentTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.dvrOperations = new DvrTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.frontendOperations = new FrontendTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.guideOperations = new GuideTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.mythOperations = new MythTemplate(this.getRestOperations(), this.getApiUrlBase());
        this.videoOperations = new VideoTemplate(this.getRestOperations(), this.getApiUrlBase());
    }
}

