/*
 * Decompiled with CFR 0.152.
 */
package org.mythtv.services.api;

import java.net.URI;
import java.util.Collections;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.mythtv.services.api.ETagInfo;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.social.support.URIBuilder;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractOperations {
    private static final String TAG = AbstractOperations.class.getSimpleName();
    private static final String MYTHTV_ETAG = "If-None-Match";
    protected static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private final String apiUrlBase;
    private final Logger logger;
    private static final LinkedMultiValueMap<String, String> EMPTY_PARAMETERS = new LinkedMultiValueMap();

    public AbstractOperations(String apiUrlBase) {
        this.apiUrlBase = apiUrlBase;
        this.logger = Logger.getLogger(TAG);
    }

    protected URI buildUri(String path) {
        this.logger.info(this.buildUri(path, (MultiValueMap<String, String>)EMPTY_PARAMETERS).toString());
        return this.buildUri(path, (MultiValueMap<String, String>)EMPTY_PARAMETERS);
    }

    protected URI buildUri(String path, String parameterName, String parameterValue) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.set((Object)parameterName, (Object)parameterValue);
        return this.buildUri(path, (MultiValueMap<String, String>)parameters);
    }

    protected URI buildUri(String path, MultiValueMap<String, String> parameters) {
        this.logger.warning("URI : " + URIBuilder.fromUri((String)(this.getApiUrlBase() + path)).queryParams(parameters).build());
        return URIBuilder.fromUri((String)(this.getApiUrlBase() + path)).queryParams(parameters).build();
    }

    protected String getApiUrlBase() {
        return this.apiUrlBase;
    }

    protected HttpEntity<?> getRequestEntity(ETagInfo info) {
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        if (info != null && !info.isEmptyEtag()) {
            requestHeaders.setETag(info.getETag());
            requestHeaders.add(MYTHTV_ETAG, info.getETag());
        }
        return new HttpEntity((MultiValueMap)requestHeaders);
    }

    protected void handleResponseEtag(ETagInfo etagInfo, HttpHeaders headers) {
        if (etagInfo != null) {
            etagInfo.setETag(headers.getETag());
        }
    }

    protected String convertUtcAndFormat(DateTime dt) {
        return formatter.print((ReadableInstant)dt.withZone(DateTimeZone.UTC));
    }
}

