/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.scent.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.Collection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.myire.quill.scent.ScentRunner;
import org.myire.quill.scent.impl.CollectingFileVisitor;
import org.myire.scent.Main;
import org.myire.scent.collect.JavaLanguageLevel;
import org.myire.scent.collect.JavaMetricsCollector;
import org.myire.scent.report.MetricsReportMetaData;
import org.myire.scent.report.XmlReportWriter;

public class ScentRunnerImpl
implements ScentRunner {
    private final Logger fLogger = Logging.getLogger(ScentRunnerImpl.class);

    @Override
    public void collectMetricsAsXml(Collection<File> pFiles, Charset pCharset, int pLanguageLevel, boolean pEnableLanguagePreviews, File pReportFile) throws IOException {
        JavaLanguageLevel aLanguageLevel;
        JavaLanguageLevel javaLanguageLevel = aLanguageLevel = pLanguageLevel == 0 ? JavaLanguageLevel.getDefault() : JavaLanguageLevel.forNumericValue((int)pLanguageLevel);
        if (aLanguageLevel == null) {
            aLanguageLevel = JavaLanguageLevel.getDefault();
            this.fLogger.error("Java language level " + pLanguageLevel + " is not supported, using default level " + aLanguageLevel.getNumericValue());
        }
        JavaMetricsCollector aCollector = new JavaMetricsCollector(aLanguageLevel, pEnableLanguagePreviews);
        CollectingFileVisitor aVisitor = new CollectingFileVisitor(aCollector, pCharset);
        for (File aJavaFile : pFiles) {
            try {
                Files.walkFileTree(aJavaFile.toPath(), aVisitor);
            }
            catch (IOException e) {
                this.fLogger.error("Error when collecting metrics from " + aJavaFile + ": " + e.getMessage());
            }
        }
        try (FileOutputStream aStream = new FileOutputStream(pReportFile);){
            MetricsReportMetaData aReportMetaData = new MetricsReportMetaData(LocalDateTime.now().withNano(0), Main.class.getPackage().getImplementationVersion());
            XmlReportWriter aReportWriter = new XmlReportWriter((OutputStream)aStream);
            aReportWriter.writeReport(aCollector.getCollectedMetrics(), aReportMetaData);
        }
    }
}

