/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.myire.quill.report.Reports;

public class ReportWriter
implements Closeable {
    private static final char[] LINE_BREAK = System.getProperty("line.separator").toCharArray();
    private static final char[] INDENTATION = new char[]{' ', ' '};
    private final Writer fWriter;
    private int fIndentationLevel;

    public ReportWriter(SingleFileReport pReport, Charset pCharset, OpenOption ... pOpenOptions) throws IOException {
        this.fWriter = new OutputStreamWriter(Files.newOutputStream(Reports.getOutputLocation((Report)pReport).toPath(), pOpenOptions), pCharset);
    }

    public void increaseIndentationLevel() {
        ++this.fIndentationLevel;
    }

    public void decreaseIndentationLevel() {
        --this.fIndentationLevel;
    }

    public void writeIndentation() throws IOException {
        for (int i = 0; i < this.fIndentationLevel; ++i) {
            this.write(INDENTATION);
        }
    }

    public void writeLineBreak() throws IOException {
        this.write(LINE_BREAK);
    }

    public void write(char pChar) throws IOException {
        this.fWriter.write(pChar);
    }

    public void write(char[] pChars) throws IOException {
        this.fWriter.write(pChars);
    }

    public void write(String pChars) throws IOException {
        this.fWriter.write(pChars);
    }

    public void flush() throws IOException {
        this.fWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.fWriter.close();
    }
}

