/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import groovy.lang.Closure;
import java.io.File;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.reporting.Report;
import org.myire.quill.common.Projects;
import org.myire.quill.report.AbstractTransformingReport;
import org.myire.quill.report.Reports;

public class ReportTransformingReport
extends AbstractTransformingReport {
    private final Report fInput;

    public ReportTransformingReport(Project pProject, String pName, String pDisplayName, Report pInput, String pXslResource) {
        super(pProject, pName, pDisplayName, pXslResource, (Closure<File>)new DefaultDestination(pProject, pInput, pName));
        this.fInput = pInput;
    }

    @Override
    public boolean reportIsRequired() {
        return super.reportIsRequired() && Reports.isRequired(this.fInput);
    }

    @Override
    protected File getInputFile() {
        return Reports.getOutputLocation(this.fInput);
    }

    private static class DefaultDestination
    extends Closure<File> {
        private final Project fProject;
        private final Report fInput;
        private final String fDefaultBaseName;

        DefaultDestination(Project pProject, Report pInput, String pDefaultBaseName) {
            super(null);
            this.fProject = Objects.requireNonNull(pProject);
            this.fInput = Objects.requireNonNull(pInput);
            this.fDefaultBaseName = pDefaultBaseName;
        }

        public File doCall(Object pValue) {
            File aInputFile = Reports.getOutputLocation(this.fInput);
            if (aInputFile != null) {
                return new File(aInputFile.getParentFile(), aInputFile.getName().replace(".xml", ".html"));
            }
            return Projects.createReportDirectorySpec(this.fProject, this.fDefaultBaseName + ".html");
        }
    }
}

