/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.myire.quill.common.Projects;
import org.myire.quill.report.DocTypeFilterStream;

public class ReportBuilder {
    private static final Logger cLogger = Logging.getLogger(ReportBuilder.class);
    private static final TransformerFactory cFactory = TransformerFactory.newInstance();
    private final File fDestination;
    private final OutputStream fOutputStream;

    public ReportBuilder(File pDestination) throws FileNotFoundException {
        this.fDestination = pDestination;
        Projects.ensureParentExists(pDestination);
        this.fOutputStream = new FileOutputStream(pDestination);
    }

    public File getDestination() {
        return this.fDestination;
    }

    public void close() {
        try {
            this.fOutputStream.close();
        }
        catch (IOException ioe) {
            cLogger.error("Failed to close report file", (Throwable)ioe);
        }
    }

    public void write(String pString) {
        this.write(pString, Charset.defaultCharset());
    }

    public void write(String pString, Charset pCharset) {
        try {
            this.fOutputStream.write(pString.getBytes(pCharset));
        }
        catch (IOException ioe) {
            cLogger.error("Failed to write string '{}'", (Object)pString, (Object)ioe);
        }
    }

    public void copy(File pFile) {
        try {
            Files.copy(pFile.toPath(), this.fOutputStream);
        }
        catch (IOException ioe) {
            cLogger.error("Failed to copy file '{}'", (Object)pFile.getAbsolutePath(), (Object)ioe);
        }
    }

    public void copy(String pResource) {
        try (InputStream aResourceStream = this.getClass().getResourceAsStream(pResource);){
            if (aResourceStream != null) {
                int aNumBytes;
                byte[] aBuffer = new byte[8192];
                while ((aNumBytes = aResourceStream.read(aBuffer)) >= 0) {
                    this.fOutputStream.write(aBuffer, 0, aNumBytes);
                }
            } else {
                cLogger.debug("Resource '{}' is not available, skipping", (Object)pResource);
            }
        }
        catch (IOException ioe) {
            cLogger.error("Failed to copy resource '{}'", (Object)pResource, (Object)ioe);
        }
    }

    public void transform(File pXmlFile, File pXslFile, Map<String, Object> pParameters) {
        Transformer aTransformer = ReportBuilder.createTransformer(pXslFile);
        if (aTransformer != null) {
            this.doTransform(aTransformer, pXmlFile, pParameters);
        }
    }

    public void transform(File pXmlFile, String pXslResource, Map<String, Object> pParameters) {
        Transformer aTransformer = ReportBuilder.createTransformer(pXslResource);
        if (aTransformer != null) {
            this.doTransform(aTransformer, pXmlFile, pParameters);
        }
    }

    public void transform(String pXml, String pXslResource, Map<String, Object> pParameters) {
        Transformer aTransformer = ReportBuilder.createTransformer(pXslResource);
        if (aTransformer != null) {
            this.doTransform(aTransformer, pXml, pParameters);
        }
    }

    private void doTransform(Transformer pTransformer, File pXmlFile, Map<String, Object> pParameters) {
        LocalDateTime aLastModified = LocalDateTime.ofInstant(Instant.ofEpochMilli(pXmlFile.lastModified()), ZoneId.systemDefault());
        pTransformer.setParameter("xml-modified-date", DateTimeFormatter.ISO_LOCAL_DATE.format(aLastModified));
        pTransformer.setParameter("xml-modified-time", DateTimeFormatter.ISO_LOCAL_TIME.format(aLastModified));
        if (pParameters != null) {
            pParameters.forEach(pTransformer::setParameter);
        }
        try (DocTypeFilterStream aFileStream = new DocTypeFilterStream(new FileInputStream(pXmlFile));){
            pTransformer.transform(new StreamSource(aFileStream), new StreamResult(this.fOutputStream));
        }
        catch (IOException e) {
            cLogger.error("Failed to access XML file '{}'", (Object)pXmlFile.getAbsolutePath(), (Object)e);
        }
        catch (TransformerException e) {
            cLogger.error("Failed to transform XML file '{}'", (Object)pXmlFile.getAbsolutePath(), (Object)e);
        }
    }

    private void doTransform(Transformer pTransformer, String pXml, Map<String, Object> pParameters) {
        if (pParameters != null) {
            pParameters.forEach(pTransformer::setParameter);
        }
        try {
            pTransformer.transform(new StreamSource(new StringReader(pXml)), new StreamResult(this.fOutputStream));
        }
        catch (TransformerException e) {
            cLogger.error("Failed to transform XML '{}'", (Object)pXml, (Object)e);
        }
    }

    private static Transformer createTransformer(File pXslFile) {
        try {
            cLogger.debug("Creating transformer from file '{}'", (Object)pXslFile.getAbsolutePath());
            return cFactory.newTransformer(new StreamSource(pXslFile));
        }
        catch (TransformerException e) {
            cLogger.error("Failed to create a transformer from file '{}'", (Object)pXslFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Transformer createTransformer(String pXslResource) {
        cLogger.debug("Loading XSL resource '{}'", (Object)pXslResource);
        try (InputStream aResourceStream = ReportBuilder.class.getResourceAsStream(pXslResource);){
            if (aResourceStream != null) {
                cLogger.debug("Creating transformer from XSL resource '{}'", (Object)pXslResource);
                Transformer transformer = cFactory.newTransformer(new StreamSource(aResourceStream));
                return transformer;
            }
            cLogger.error("Could not load XSL resource '{}'", (Object)pXslResource);
            return null;
        }
        catch (IOException ioe) {
            cLogger.error("Could not load XSL resource '{}'", (Object)pXslResource, (Object)ioe);
            return null;
        }
        catch (TransformerException te) {
            cLogger.error("Failed to create a transformer from resource '{}'", (Object)pXslResource, (Object)te);
        }
        return null;
    }
}

