/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import groovy.lang.Closure;
import java.io.File;
import java.util.Locale;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.common.Projects;
import org.myire.quill.common.Tasks;
import org.myire.quill.report.DefaultSingleFileReport;
import org.myire.quill.report.ReportTransformingReport;
import org.myire.quill.report.Reports;
import org.myire.quill.report.TransformingReport;
import org.myire.quill.report.XmlHtmlReportSet;

public abstract class AbstractXmlHtmlReportSet<T extends XmlHtmlReportSet<T>>
implements XmlHtmlReportSet<T> {
    private final SingleFileReport fXmlReport;
    private final TransformingReport fHtmlReport;
    private final String fXmlReportName;
    private final String fHtmlReportName;

    protected AbstractXmlHtmlReportSet(Task pTask, String pReportSetName, String pXslResourcePath) {
        Project aProject = pTask.getProject();
        String aLowerCaseName = pReportSetName.toLowerCase(Locale.getDefault());
        this.fXmlReportName = aLowerCaseName + "Xml";
        this.fHtmlReportName = aLowerCaseName + "Html";
        this.fXmlReport = new DefaultSingleFileReport(aProject, this.fXmlReportName, pReportSetName + " XML report", new DefaultXmlReportDestination(aProject, aLowerCaseName));
        this.fHtmlReport = new ReportTransformingReport(aProject, this.fHtmlReportName, pReportSetName + " HTML report", (Report)this.fXmlReport, pXslResourcePath);
        Reports.setRequired((Report)this.fXmlReport, true);
        Reports.setRequired((Report)this.fHtmlReport, true);
    }

    @Override
    public SingleFileReport getXml() {
        return this.fXmlReport;
    }

    @Override
    public TransformingReport getHtml() {
        return this.fHtmlReport;
    }

    @Override
    public Report getReportByName(String pReportName) {
        if (this.fXmlReportName.equalsIgnoreCase(pReportName)) {
            return this.fXmlReport;
        }
        if (this.fHtmlReportName.equalsIgnoreCase(pReportName)) {
            return this.fHtmlReport;
        }
        return null;
    }

    public T configure(Closure pClosure) {
        ConfigureUtil.configureSelf((Closure)pClosure, (Object)this);
        return this.self();
    }

    public void setInputsAndOutputs(Task pTask) {
        Tasks.inputProperty(pTask, "xmlReportEnabled", () -> Reports.isRequired((Report)this.fXmlReport));
        Tasks.inputProperty(pTask, "htmlReportEnabled", () -> Reports.isRequired((Report)this.fHtmlReport));
        Tasks.optionalInputFile(pTask, this.fHtmlReport::getXslFile);
        Tasks.outputFile(pTask, () -> ((SingleFileReport)this.fXmlReport).getDestination());
        Tasks.outputFile(pTask, () -> ((TransformingReport)this.fHtmlReport).getDestination());
        pTask.getOutputs().upToDateWhen(_ignore -> this.fHtmlReport.checkUpToDate());
    }

    protected abstract T self();

    private static class DefaultXmlReportDestination
    extends Closure<File> {
        private final Project fProject;
        private final String fBaseName;

        DefaultXmlReportDestination(Project pProject, String pBaseName) {
            super(null);
            this.fProject = pProject;
            this.fBaseName = pBaseName;
        }

        public File doCall(Object pValue) {
            return new File(Projects.createReportDirectorySpec(this.fProject, this.fBaseName), this.fBaseName + ".xml");
        }
    }
}

