/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.jol;

import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.gradle.api.reporting.SingleFileReport;
import org.myire.quill.jol.JolResult;
import org.myire.quill.report.XmlReportWriter;

class JolXmlReportWriter
extends XmlReportWriter {
    private static final String ELEMENT_REPORT = "jol-report";
    private static final String ELEMENT_PACKAGES = "packages";
    private static final String ELEMENT_PACKAGE = "package";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_FIELD = "field";

    JolXmlReportWriter(SingleFileReport pReport) throws IOException {
        super(pReport, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    void writeReport(JolResult pResult) throws IOException {
        this.writeProlog();
        this.writeElement(ELEMENT_REPORT, this::writeReportAttributes, this::writePackages, pResult);
    }

    private void writeReportAttributes(JolResult pResult) throws IOException {
        LocalDateTime aTimestamp = LocalDateTime.now().withNano(0);
        this.writeAttribute("date", DateTimeFormatter.ISO_DATE.format(aTimestamp));
        this.writeAttribute("time", DateTimeFormatter.ISO_LOCAL_TIME.format(aTimestamp));
        this.writeAttribute("version", pResult.getVersion());
        this.writeAttribute("description", pResult.getDescription());
        this.writeAttribute("total-internal-gap-size", pResult.getInternalAlignmentGapSize());
        this.writeAttribute("total-external-gap-size", pResult.getExternalAlignmentGapSize());
    }

    private void writePackages(JolResult pResult) throws IOException {
        if (pResult.getNumPackages() > 0) {
            this.writeSequence(ELEMENT_PACKAGES, ELEMENT_PACKAGE, this::writePackageAttributes, this::writePackageBody, pResult.getPackages());
        } else {
            this.writeEmptyElement(ELEMENT_PACKAGES);
        }
    }

    private void writePackageAttributes(JolResult.PackageLayout pPackageLayout) throws IOException {
        this.writeAttribute("name", pPackageLayout.getName());
        this.writeAttribute("total-internal-gap-size", pPackageLayout.getInternalAlignmentGapSize());
        this.writeAttribute("total-external-gap-size", pPackageLayout.getExternalAlignmentGapSize());
    }

    private void writePackageBody(JolResult.PackageLayout pPackageLayout) throws IOException {
        for (JolResult.ClassLayout aClassLayout : pPackageLayout.getClasses()) {
            if (aClassLayout.getNumFields() > 0) {
                this.writeElement(ELEMENT_CLASS, this::writeClassAttributes, this::writeClassBody, aClassLayout);
                continue;
            }
            this.writeEmptyElement(ELEMENT_CLASS, this::writeClassAttributes, aClassLayout);
        }
    }

    private void writeClassAttributes(JolResult.ClassLayout pClassLayout) throws IOException {
        this.writeAttribute("name", pClassLayout.getFullClassName());
        this.writeAttribute("header-size", pClassLayout.getHeaderSize());
        this.writeAttribute("instance-size", pClassLayout.getInstanceSize());
        this.writeAttribute("internal-gaps", pClassLayout.getInternalAlignmentGapSize());
        this.writeAttribute("external-gaps", pClassLayout.getExternalAlignmentGapSize());
    }

    private void writeClassBody(JolResult.ClassLayout pClassLayout) throws IOException {
        for (JolResult.FieldLayout aFieldLayout : pClassLayout.getFields()) {
            this.writeEmptyElement(ELEMENT_FIELD, this::writeFieldAttributes, aFieldLayout);
        }
    }

    private void writeFieldAttributes(JolResult.FieldLayout pFieldLayout) throws IOException {
        this.writeAttribute("name", pFieldLayout.getName());
        this.writeAttribute("type", pFieldLayout.getType());
        this.writeAttribute("offset", pFieldLayout.getOffset());
        this.writeAttribute("size", pFieldLayout.getSize());
    }
}

