/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dependency;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.gradle.api.Project;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.PrettyPrintable;
import org.myire.quill.dependency.ArtifactSpec;
import org.myire.quill.dependency.ExclusionSpec;

public abstract class DependencySpec
implements PrettyPrintable {
    private static final String CLOSURE_DEPENDENCIES = "dependencies";
    private static final String ATTRIBUTE_TRANSITIVE = "transitive";
    private String fConfiguration;
    private boolean fTransitive = true;
    private final List<ExclusionSpec> fExclusions = new ArrayList<ExclusionSpec>();
    private final List<ArtifactSpec> fArtifacts = new ArrayList<ArtifactSpec>();

    protected DependencySpec(String pConfiguration) {
        this.fConfiguration = Objects.requireNonNull(pConfiguration);
    }

    public String getConfiguration() {
        return this.fConfiguration;
    }

    public void setConfiguration(String pConfiguration) {
        this.fConfiguration = Objects.requireNonNull(pConfiguration);
    }

    public boolean isTransitive() {
        return this.fTransitive;
    }

    public void setTransitive(boolean pTransitive) {
        this.fTransitive = pTransitive;
    }

    public int getNumExclusions() {
        return this.fExclusions.size();
    }

    public void forEachExclusion(Consumer<? super ExclusionSpec> pAction) {
        this.fExclusions.forEach(pAction);
    }

    public void addExclusion(ExclusionSpec pExclusionSpec) {
        this.fExclusions.add(pExclusionSpec);
    }

    public void addExclusion(String pGroup, String pModule) {
        this.fExclusions.add(new ExclusionSpec(pGroup, pModule));
    }

    public int getNumArtifacts() {
        return this.fArtifacts.size();
    }

    public void forEachArtifact(Consumer<? super ArtifactSpec> pAction) {
        this.fArtifacts.forEach(pAction);
    }

    public void addArtifact(ArtifactSpec pArtifactSpec) {
        this.fArtifacts.add(pArtifactSpec);
    }

    public void addArtifact(String pName, String pType, String pExtension, String pClassifier, String pUrl) {
        this.fArtifacts.add(new ArtifactSpec(pName, pType, pExtension, pClassifier, pUrl));
    }

    public void setValues(DependencySpec pValues) {
        this.fTransitive = pValues.isTransitive();
        this.fArtifacts.addAll(pValues.fArtifacts);
        this.fExclusions.addAll(pValues.fExclusions);
    }

    public abstract String toDependencyNotation();

    public abstract boolean addTo(Project var1);

    public static void prettyPrintDependencies(GradlePrettyPrinter pPrinter, Collection<? extends DependencySpec> pDependencies) {
        if (pDependencies.size() > 0) {
            pPrinter.printClosure(CLOSURE_DEPENDENCIES, p -> pDependencies.forEach(d -> d.prettyPrint((GradlePrettyPrinter)p)));
        }
    }

    protected boolean hasNonDefaultAttribute() {
        return !this.fTransitive || !this.fExclusions.isEmpty() || !this.fArtifacts.isEmpty();
    }

    protected void printClosureBody(GradlePrettyPrinter pPrinter) {
        if (!this.fTransitive) {
            pPrinter.printAttribute(ATTRIBUTE_TRANSITIVE, this.fTransitive);
        }
        this.fExclusions.forEach(e -> e.prettyPrint(pPrinter));
        this.fArtifacts.forEach(a -> a.prettyPrint(pPrinter));
    }
}

