/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.dashboard;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.common.Projects;
import org.myire.quill.dashboard.DashboardReports;
import org.myire.quill.dashboard.DashboardTask;
import org.myire.quill.report.DefaultSingleFileReport;
import org.myire.quill.report.Reports;

class DashboardReportsImpl
implements DashboardReports {
    private static final String HTML_REPORT_NAME = "html";
    private final SingleFileReport fHtmlReport;

    DashboardReportsImpl(DashboardTask pTask) {
        this.fHtmlReport = new DefaultSingleFileReport(pTask.getProject(), HTML_REPORT_NAME, "Dashboard HTML report", new DefaultReportDestination(pTask.getProject()));
        Reports.setRequired((Report)this.fHtmlReport, true);
    }

    @Override
    public SingleFileReport getHtml() {
        return this.fHtmlReport;
    }

    @Override
    public Report getReportByName(String pReportName) {
        return HTML_REPORT_NAME.equalsIgnoreCase(pReportName) ? this.fHtmlReport : null;
    }

    public DashboardReports configure(Closure pClosure) {
        ConfigureUtil.configureSelf((Closure)pClosure, (Object)this);
        return this;
    }

    private static class DefaultReportDestination
    extends Closure<File> {
        private final Project fProject;

        DefaultReportDestination(Project pProject) {
            super(null);
            this.fProject = pProject;
        }

        public File doCall(Object pValue) {
            return Projects.createReportDirectorySpec(this.fProject, "reportsDashboard.html");
        }
    }
}

