/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.cpd;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.reporting.Report;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.VersionNumber;
import org.myire.quill.common.ExternalToolLoader;
import org.myire.quill.common.Projects;
import org.myire.quill.common.Tasks;
import org.myire.quill.cpd.CpdParameters;
import org.myire.quill.cpd.CpdReports;
import org.myire.quill.cpd.CpdReportsImpl;
import org.myire.quill.cpd.CpdRunner;
import org.myire.quill.report.FormatChoiceReport;
import org.myire.quill.report.ReportingEntity;
import org.myire.quill.report.Reports;
import org.myire.quill.report.TransformingReport;

public class CpdTask
extends SourceTask
implements ReportingEntity<CpdReports> {
    private static final VersionNumber MINIMUM_TOOL_VERSION = VersionNumber.parse((String)"6.1.0");
    private static final String DEFAULT_TOOL_VERSION = "6.41.0";
    private static final String PMD_EXTENSION_NAME = "pmd";
    private static final String IMPLEMENTATION_PACKAGE = "org.myire.quill.cpd.impl.";
    private static final String IMPLEMENTATION_CLASS = "CpdRunnerImpl";
    private String fToolVersion;
    private FileCollection fCpdClasspath;
    private CpdReports fReports;
    private final CpdParameters fCpdParameters = new CpdParameters();

    @InputFiles
    @SkipWhenEmpty
    public FileTree getSource() {
        SourceSet aMainSourceSet;
        FileTree aSource = super.getSource();
        if ((aSource == null || aSource.isEmpty()) && (aMainSourceSet = Projects.getSourceSet(this.getProject(), "main")) != null) {
            aSource = aMainSourceSet.getAllJava();
            this.setSource(aSource);
        }
        return aSource;
    }

    @Input
    public String getToolVersion() {
        if (this.fToolVersion == null) {
            VersionNumber aPmdVersion = this.parsePmdVersion();
            this.fToolVersion = aPmdVersion != null && aPmdVersion.compareTo(MINIMUM_TOOL_VERSION) >= 0 ? aPmdVersion.toString() : DEFAULT_TOOL_VERSION;
        }
        return this.fToolVersion;
    }

    public void setToolVersion(String pToolVersion) {
        this.fToolVersion = pToolVersion;
    }

    @InputFiles
    public FileCollection getCpdClasspath() {
        return this.fCpdClasspath;
    }

    public void setCpdClasspath(FileCollection pCpdClasspath) {
        this.fCpdClasspath = pCpdClasspath;
    }

    @Override
    @Nested
    public CpdReports getReports() {
        return this.fReports;
    }

    @Override
    public CpdReports reports(Closure pClosure) {
        this.fReports.configure(pClosure);
        return this.fReports;
    }

    @Override
    public CpdReports reports(Action<? super CpdReports> pAction) {
        pAction.execute((Object)this.fReports);
        return this.fReports;
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.fCpdParameters.getEncoding();
    }

    public void setEncoding(String pEncoding) {
        this.fCpdParameters.setEncoding(pEncoding);
    }

    @Input
    @Optional
    public String getLanguage() {
        return this.fCpdParameters.getLanguage();
    }

    public void setLanguage(String pLanguage) {
        this.fCpdParameters.setLanguage(pLanguage);
    }

    @Input
    public int getMinimumTokenCount() {
        return this.fCpdParameters.getMinimumTokenCount();
    }

    public void setMinimumTokenCount(int pMinimumTokenCount) {
        this.fCpdParameters.setMinimumTokenCount(pMinimumTokenCount);
    }

    @Input
    public boolean isIgnoreLiterals() {
        return this.fCpdParameters.isIgnoreLiterals();
    }

    public void setIgnoreLiterals(boolean pIgnoreLiterals) {
        this.fCpdParameters.setIgnoreLiterals(pIgnoreLiterals);
    }

    @Input
    public boolean isIgnoreIdentifiers() {
        return this.fCpdParameters.isIgnoreIdentifiers();
    }

    public void setIgnoreIdentifiers(boolean pIgnoreIdentifiers) {
        this.fCpdParameters.setIgnoreIdentifiers(pIgnoreIdentifiers);
    }

    @Input
    public boolean isIgnoreAnnotations() {
        return this.fCpdParameters.isIgnoreAnnotations();
    }

    public void setIgnoreAnnotations(boolean pIgnoreAnnotations) {
        this.fCpdParameters.setIgnoreAnnotations(pIgnoreAnnotations);
    }

    @Input
    public boolean isSkipDuplicateFiles() {
        return this.fCpdParameters.isSkipDuplicateFiles();
    }

    public void setSkipDuplicateFiles(boolean pSkipDuplicateFiles) {
        this.fCpdParameters.setSkipDuplicateFiles(pSkipDuplicateFiles);
    }

    @Input
    public boolean isSkipLexicalErrors() {
        return this.fCpdParameters.isSkipLexicalErrors();
    }

    public void setSkipLexicalErrors(boolean pSkipLexicalErrors) {
        this.fCpdParameters.setSkipLexicalErrors(pSkipLexicalErrors);
    }

    @Input
    public boolean isSkipBlocks() {
        return this.fCpdParameters.isSkipBlocks();
    }

    public void setSkipBlocks(boolean pSkipBlocks) {
        this.fCpdParameters.setSkipBlocks(pSkipBlocks);
    }

    @Input
    @Optional
    public String getSkipBlocksPattern() {
        return this.fCpdParameters.getSkipBlocksPattern();
    }

    public void setSkipBlocksPattern(String pSkipBlocksPattern) {
        this.fCpdParameters.setSkipBlocksPattern(pSkipBlocksPattern);
    }

    @Input
    public boolean isIgnoreUsings() {
        return this.fCpdParameters.isIgnoreUsings();
    }

    public void setIgnoreUsings(boolean pIgnoreUsings) {
        this.fCpdParameters.setIgnoreUsings(pIgnoreUsings);
    }

    @TaskAction
    public void run() {
        FormatChoiceReport aPrimaryReport = this.fReports.getPrimary();
        if (Reports.isRequired((Report)aPrimaryReport)) {
            Projects.ensureParentExists(Reports.getOutputLocation((Report)aPrimaryReport));
            this.runCpd(aPrimaryReport);
            TransformingReport aHtmlReport = this.fReports.getHtml();
            if (Reports.isRequired((Report)aHtmlReport) && "xml".equals(aPrimaryReport.getFormat())) {
                aHtmlReport.transform();
            }
        } else {
            this.getLogger().info("CPD primary is report disabled, skipping analysis");
        }
    }

    private void runCpd(FormatChoiceReport pPrimaryReport) {
        try {
            this.loadCpdRunner().runCpd(this.getSource().getFiles(), Reports.getOutputLocation((Report)pPrimaryReport), pPrimaryReport.getFormat(), this.fCpdParameters);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            this.getLogger().error("Could not create an instance of '{}{}'", new Object[]{IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, e});
        }
        catch (IOException ioe) {
            this.getLogger().error("Could not perform CPD analysis", (Throwable)ioe);
        }
    }

    void setupReports() {
        this.fReports = new CpdReportsImpl(this);
        this.onlyIf(ignore -> Reports.isRequired((Report)this.getReports().getPrimary()));
        Tasks.inputProperty((Task)this, "'primaryReportEnabled'", () -> Reports.isRequired((Report)this.getReports().getPrimary()));
        Tasks.inputProperty((Task)this, "htmlReportEnabled", () -> Reports.isRequired((Report)this.getReports().getHtml()));
        Tasks.optionalInputFile((Task)this, () -> this.getReports().getHtml().getXslFile());
        Tasks.outputFile((Task)this, () -> Reports.getOutputLocation((Report)this.getReports().getPrimary()));
        Tasks.outputFile((Task)this, () -> Reports.getOutputLocation((Report)this.getReports().getHtml()));
    }

    void addUpToDateCheck() {
        this.getOutputs().upToDateWhen(ignore -> this.getReports().getHtml().checkUpToDate());
    }

    File defaultPrimaryDestination() {
        String aExtension = this.getReports().getPrimary().getFormat();
        if ("csv_with_linecount_per_file".equals(aExtension)) {
            aExtension = "csv";
        }
        return new File(Projects.createReportDirectorySpec(this.getProject(), "cpd"), "cpd." + aExtension);
    }

    private CpdRunner loadCpdRunner() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ExternalToolLoader<CpdRunner> aLoader = new ExternalToolLoader<CpdRunner>(CpdRunner.class, IMPLEMENTATION_PACKAGE, IMPLEMENTATION_CLASS, this::getCpdClasspath);
        return aLoader.createToolProxy();
    }

    private VersionNumber parsePmdVersion() {
        PmdExtension aPmdExtension = Projects.getExtension(this.getProject(), PMD_EXTENSION_NAME, PmdExtension.class);
        return aPmdExtension != null ? VersionNumber.parse((String)aPmdExtension.getToolVersion()) : null;
    }
}

