/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.cpd;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.myire.quill.common.Projects;
import org.myire.quill.cpd.CpdTask;

public class CpdPlugin
implements Plugin<Project> {
    private static final String TASK_NAME = "cpd";
    private static final String CONFIGURATION_NAME = "cpd";
    private static final String CPD_GROUP_ARTIFACT_ID = "net.sourceforge.pmd:pmd-dist";
    private Project fProject;
    private CpdTask fTask;
    private Configuration fConfiguration;

    public void apply(Project pProject) {
        this.fProject = pProject;
        pProject.getPlugins().apply(JavaBasePlugin.class);
        this.fConfiguration = this.createConfiguration();
        this.fTask = this.createCpdTask();
    }

    private Configuration createConfiguration() {
        Configuration aConfiguration = (Configuration)this.fProject.getConfigurations().maybeCreate("cpd");
        aConfiguration.setVisible(false);
        aConfiguration.setTransitive(true);
        aConfiguration.setDescription("The CPD classes used by the CPD task");
        aConfiguration.getIncoming().beforeResolve(ignore -> this.setConfigurationDependencies());
        return aConfiguration;
    }

    private void setConfigurationDependencies() {
        if (this.fConfiguration.getDependencies().isEmpty()) {
            String aID = "net.sourceforge.pmd:pmd-dist:" + this.fTask.getToolVersion();
            this.fConfiguration.getDependencies().add((Object)this.fProject.getDependencies().create((Object)aID));
        }
    }

    private CpdTask createCpdTask() {
        CpdTask aTask = (CpdTask)this.fProject.getTasks().create("cpd", CpdTask.class);
        aTask.setDescription("Performs copy-paste detection on the main source files");
        aTask.setGroup("verification");
        aTask.setCpdClasspath((FileCollection)this.fConfiguration);
        aTask.setupReports();
        aTask.addUpToDateCheck();
        Task aCheckTask = Projects.getTask(this.fProject, "check", Task.class);
        if (aCheckTask != null) {
            aCheckTask.dependsOn(new Object[]{aTask});
        }
        return aTask;
    }
}

