/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.configuration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.myire.quill.common.GradlePrettyPrinter;
import org.myire.quill.common.PrettyPrintable;

public class ConfigurationSpec
implements PrettyPrintable {
    private static final String CLOSURE_CONFIGURATIONS = "configurations";
    private static final String ATTRIBUTE_TRANSITIVE = "transitive";
    private static final String ATTRIBUTE_VISIBLE = "visible";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_EXTENDS = "extendsFrom";
    private final String fName;
    private final Set<String> fExtendedConfigurations = new LinkedHashSet<String>();
    private boolean fTransitive = true;
    private boolean fVisible = true;
    private String fDescription;

    public ConfigurationSpec(String pName) {
        this.fName = Objects.requireNonNull(pName);
    }

    public String getName() {
        return this.fName;
    }

    public boolean isTransitive() {
        return this.fTransitive;
    }

    public void setTransitive(boolean pTransitive) {
        this.fTransitive = pTransitive;
    }

    public boolean isVisible() {
        return this.fVisible;
    }

    public void setVisible(boolean pVisible) {
        this.fVisible = pVisible;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String pDescription) {
        this.fDescription = pDescription;
    }

    public int getNumExtendedConfigurations() {
        return this.fExtendedConfigurations.size();
    }

    public void forEachExtendedConfiguration(Consumer<? super String> pAction) {
        this.fExtendedConfigurations.forEach(pAction);
    }

    public void addExtendedConfiguration(String pConfigurationName) {
        this.fExtendedConfigurations.add(Objects.requireNonNull(pConfigurationName));
    }

    @Override
    public void prettyPrint(GradlePrettyPrinter pPrinter) {
        if (this.hasNonDefaultAttribute()) {
            pPrinter.printClosure(this.fName, this::printClosureBody);
        } else {
            pPrinter.printIndentedLine(this.fName);
        }
    }

    public static void prettyPrintConfigurations(GradlePrettyPrinter pPrinter, Collection<? extends ConfigurationSpec> pConfigurations) {
        if (pConfigurations.size() > 0) {
            pPrinter.printClosure(CLOSURE_CONFIGURATIONS, p -> pConfigurations.forEach(c -> c.prettyPrint((GradlePrettyPrinter)p)));
        }
    }

    private void printClosureBody(GradlePrettyPrinter pPrinter) {
        if (!this.fTransitive) {
            pPrinter.printAttribute(ATTRIBUTE_TRANSITIVE, this.fTransitive);
        }
        if (!this.fVisible) {
            pPrinter.printAttribute(ATTRIBUTE_VISIBLE, this.fVisible);
        }
        pPrinter.printAttribute(ATTRIBUTE_DESCRIPTION, this.fDescription);
        pPrinter.printMethodCall(ATTRIBUTE_EXTENDS, this.extendedConfigurationsAsString(), false, false);
    }

    private String extendedConfigurationsAsString() {
        if (this.fExtendedConfigurations.isEmpty()) {
            return null;
        }
        int aNumExtended = this.fExtendedConfigurations.size();
        StringBuilder aBuffer = new StringBuilder(aNumExtended * 8);
        for (String aExtended : this.fExtendedConfigurations) {
            aBuffer.append(aExtended);
            if (--aNumExtended <= 0) continue;
            aBuffer.append(", ");
        }
        return aBuffer.toString();
    }

    private boolean hasNonDefaultAttribute() {
        return !this.fTransitive || !this.fVisible || this.fDescription != null || !this.fExtendedConfigurations.isEmpty();
    }
}

