/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.common;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.file.AbstractFileResolver;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.GFileUtils;

public final class Projects {
    private Projects() {
    }

    public static SourceSetContainer getSourceSets(Project pProject) {
        Object aProperty;
        if (pProject.hasProperty("sourceSets") && (aProperty = pProject.property("sourceSets")) instanceof SourceSetContainer) {
            return (SourceSetContainer)aProperty;
        }
        return null;
    }

    public static SourceSet getSourceSet(Project pProject, String pName) {
        SourceSetContainer aContainer = Projects.getSourceSets(pProject);
        return aContainer != null ? (SourceSet)aContainer.findByName(pName) : null;
    }

    public static <T extends Task> T getTask(Project pProject, String pName, Class<T> pTaskClass) {
        try {
            Task aTask = pProject.getTasks().getByName(pName);
            if (aTask != null && pTaskClass.isAssignableFrom(aTask.getClass())) {
                return (T)aTask;
            }
        }
        catch (UnknownTaskException unknownTaskException) {
            // empty catch block
        }
        return null;
    }

    public static <T> T getExtension(Project pProject, String pName, Class<T> pExtensionClass) {
        Object aExtension = pProject.getExtensions().findByName(pName);
        if (aExtension != null && pExtensionClass.isAssignableFrom(aExtension.getClass())) {
            return (T)aExtension;
        }
        return null;
    }

    public static <T> T getConventionPlugin(Project pProject, String pName, Class<T> pPluginClass) {
        Object aPlugin = pProject.getConvention().getPlugins().get(pName);
        if (aPlugin != null && pPluginClass.isAssignableFrom(aPlugin.getClass())) {
            return (T)aPlugin;
        }
        return null;
    }

    public static File createReportDirectorySpec(Project pProject, String pDirectoryItemName) {
        ReportingExtension aExtension = Projects.getExtension(pProject, "reporting", ReportingExtension.class);
        File aBaseDir = aExtension != null ? aExtension.getBaseDir() : pProject.getBuildDir();
        return pDirectoryItemName != null ? new File(aBaseDir, pDirectoryItemName) : aBaseDir;
    }

    public static File createTemporaryDirectorySpec(Project pProject, String pDirectoryItemName) {
        File aTmpDir = new File(pProject.getBuildDir(), "tmp");
        return pDirectoryItemName != null ? new File(aTmpDir, pDirectoryItemName) : aTmpDir;
    }

    public static FileResolver getFileResolver(Project pProject) {
        if (pProject instanceof ProjectInternal) {
            return ((ProjectInternal)pProject).getFileResolver();
        }
        return null;
    }

    public static FileResolver createBaseDirectoryFileResolver(Project pProject, Object pBaseDirectory) {
        FileResolver aProjectResolver = Projects.getFileResolver(pProject);
        if (aProjectResolver instanceof AbstractFileResolver) {
            return ((AbstractFileResolver)aProjectResolver).withBaseDir(pBaseDirectory);
        }
        return null;
    }

    public static boolean extractResource(String pResource, File pFile) {
        if (pFile.exists()) {
            return false;
        }
        Projects.ensureParentExists(pFile);
        GFileUtils.copyURLToFile((URL)Projects.class.getResource(pResource), (File)pFile);
        return true;
    }

    public static void ensureParentExists(File pFile) {
        File aParent = pFile.getParentFile();
        if (aParent != null) {
            aParent.mkdirs();
        }
    }

    static {
        try {
            new URLConnection(new URL("file:///")){
                {
                    this.setDefaultUseCaches(false);
                }

                @Override
                public void connect() {
                }
            };
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

