/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.common;

import java.io.PrintWriter;
import java.util.Objects;
import java.util.function.Consumer;
import org.myire.quill.common.PrettyPrintable;

public class GradlePrettyPrinter {
    private final PrintWriter fWriter;
    private int fIndentationLevel;

    public GradlePrettyPrinter(PrintWriter pWriter) {
        this.fWriter = Objects.requireNonNull(pWriter);
    }

    public void printClosure(String pName, Consumer<GradlePrettyPrinter> pBodyAction) {
        if (pName != null) {
            this.printIndentedLine(pName);
        }
        this.printIndentedLine("{");
        ++this.fIndentationLevel;
        pBodyAction.accept(this);
        --this.fIndentationLevel;
        this.printIndentedLine("}");
    }

    public void printAttribute(String pName, String pValue) {
        if (pValue != null) {
            this.printIndentation();
            this.fWriter.print(pName);
            this.fWriter.print(" = ");
            this.fWriter.println(PrettyPrintable.quote(pValue));
        }
    }

    public void printAttribute(String pName, boolean pValue) {
        this.printIndentation();
        this.fWriter.print(pName);
        this.fWriter.print(" = ");
        this.fWriter.println(pValue);
    }

    public void printMethodCall(String pName, String pArgument, boolean pQuote, boolean pWithParentheses) {
        if (pArgument != null) {
            if (pQuote) {
                pArgument = PrettyPrintable.quote(pArgument);
            }
            this.printIndentation();
            this.fWriter.print(pName);
            if (pWithParentheses) {
                this.fWriter.print('(');
                this.fWriter.print(pArgument);
                this.fWriter.println(')');
            } else {
                this.fWriter.print(' ');
                this.fWriter.println(pArgument);
            }
        }
    }

    public void printIndentedLine(String pLine) {
        this.printIndentation();
        this.fWriter.println(pLine);
    }

    private void printIndentation() {
        for (int i = 0; i < this.fIndentationLevel; ++i) {
            this.fWriter.print("  ");
        }
    }
}

