/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import org.gradle.api.reporting.SingleFileReport;
import org.myire.quill.report.ReportWriter;

public class XmlReportWriter
extends ReportWriter {
    private static final char[] PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".toCharArray();
    private static final FragmentWriter<?> NULL_FRAGMENT_WRITER = _x -> {};

    public XmlReportWriter(SingleFileReport pReport, OpenOption ... pOpenOptions) throws IOException {
        super(pReport, StandardCharsets.UTF_8, pOpenOptions);
    }

    public void writeProlog() throws IOException {
        this.write(PROLOG);
        this.writeLineBreak();
    }

    public <T> void writeElement(String pElementName, FragmentWriter<T> pAttributeWriter, FragmentWriter<T> pBodyWriter, T pElement) throws IOException {
        this.writeElementStart(pElementName, pAttributeWriter, pElement);
        this.increaseIndentationLevel();
        pBodyWriter.write(pElement);
        this.decreaseIndentationLevel();
        this.writeElementEnd(pElementName);
    }

    public <T> void writeElement(String pElementName, FragmentWriter<T> pBodyWriter, T pBody) throws IOException {
        this.writeElementStart(pElementName, NULL_FRAGMENT_WRITER, null);
        this.increaseIndentationLevel();
        pBodyWriter.write(pBody);
        this.decreaseIndentationLevel();
        this.writeElementEnd(pElementName);
    }

    public <T> void writeEmptyElement(String pElementName, FragmentWriter<T> pAttributeWriter, T pAttributes) throws IOException {
        this.writeIndentation();
        this.write('<');
        this.write(pElementName);
        pAttributeWriter.write(pAttributes);
        this.write('/');
        this.write('>');
        this.writeLineBreak();
    }

    public void writeEmptyElement(String pElementName) throws IOException {
        this.writeEmptyElement(pElementName, NULL_FRAGMENT_WRITER, null);
    }

    public void writeElementStart(String pElementName) throws IOException {
        this.writeElementStart(pElementName, NULL_FRAGMENT_WRITER, null);
    }

    public <T> void writeElementStart(String pElementName, FragmentWriter<T> pAttributeWriter, T pAttributes) throws IOException {
        this.writeIndentation();
        this.write('<');
        this.write(pElementName);
        pAttributeWriter.write(pAttributes);
        this.write('>');
        this.writeLineBreak();
    }

    public void writeElementEnd(String pElementName) throws IOException {
        this.writeIndentation();
        this.write('<');
        this.write('/');
        this.write(pElementName);
        this.write('>');
        this.writeLineBreak();
    }

    public <T> void writeSequence(String pRootElementName, String pChildElementName, FragmentWriter<T> pChildAttributeWriter, FragmentWriter<T> pChildBodyWriter, Iterable<T> pChildren) throws IOException {
        this.writeElementStart(pRootElementName);
        this.increaseIndentationLevel();
        for (T aChild : pChildren) {
            this.writeElement(pChildElementName, pChildAttributeWriter, pChildBodyWriter, aChild);
        }
        this.decreaseIndentationLevel();
        this.writeElementEnd(pRootElementName);
    }

    public void writeAttribute(String pName, String pValue) throws IOException {
        this.write(' ');
        this.write(pName);
        this.write('=');
        this.write('\"');
        this.writeEscaped(pValue);
        this.write('\"');
    }

    public void writeAttribute(String pName, long pValue) throws IOException {
        this.write(' ');
        this.write(pName);
        this.write('=');
        this.write('\"');
        this.write(String.valueOf(pValue));
        this.write('\"');
    }

    public void writeEscaped(String pValue) throws IOException {
        int aLength = pValue.length();
        for (int i = 0; i < aLength; ++i) {
            char aChar = pValue.charAt(i);
            if (aChar == '<') {
                this.write("&lt;");
                continue;
            }
            if (aChar == '\"') {
                this.write("&quot;");
                continue;
            }
            if (aChar == '&') {
                this.write("&amp;");
                continue;
            }
            this.write(aChar);
        }
    }

    @FunctionalInterface
    public static interface FragmentWriter<T> {
        public void write(T var1) throws IOException;
    }
}

