/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.report;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ConfigurableReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.util.ConfigureUtil;
import org.myire.quill.common.ProjectAware;

public abstract class SimpleConfigurableReport
extends ProjectAware
implements ConfigurableReport {
    private final String fName;
    private final String fDisplayName;
    private final Report.OutputType fOutputType;
    private final Property<Boolean> fRequiredProperty;
    private Object fDestination;

    protected SimpleConfigurableReport(Project pProject, String pName, String pDisplayName, Report.OutputType pOutputType) {
        super(pProject);
        this.fName = pName;
        this.fDisplayName = pDisplayName;
        this.fOutputType = pOutputType;
        this.fRequiredProperty = pProject.getObjects().property(Boolean.class);
        this.fRequiredProperty.set((Object)Boolean.FALSE);
    }

    public String getName() {
        return this.fName;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public Report.OutputType getOutputType() {
        return this.fOutputType;
    }

    public File getDestination() {
        return this.resolveDestination();
    }

    public void setDestination(File pFile) {
        this.fDestination = pFile;
    }

    public void setDestination(Provider<File> pProvider) {
        this.fDestination = pProvider;
    }

    public void setOutputLocation(Object pLocation) {
        this.useDestination(pLocation);
    }

    public boolean isEnabled() {
        return this.reportIsRequired();
    }

    public void setEnabled(boolean pEnabled) {
        this.fRequiredProperty.set((Object)pEnabled);
    }

    public void setEnabled(Provider<Boolean> pProvider) {
        this.fRequiredProperty.set(pProvider);
    }

    public Report configure(Closure pConfigureClosure) {
        return (Report)ConfigureUtil.configureSelf((Closure)pConfigureClosure, (Object)this);
    }

    @Input
    public Property<Boolean> getRequired() {
        return this.fRequiredProperty;
    }

    public void setRequired(boolean pValue) {
        this.fRequiredProperty.set((Object)pValue);
    }

    @Override
    @Internal
    public Project getProject() {
        return super.getProject();
    }

    @Override
    @Internal
    public Logger getProjectLogger() {
        return super.getProjectLogger();
    }

    public String toString() {
        return "Report " + this.getName();
    }

    protected boolean reportIsRequired() {
        return (Boolean)this.fRequiredProperty.getOrElse((Object)Boolean.FALSE);
    }

    protected File resolveDestination() {
        return this.fDestination != null ? this.getProject().file(this.fDestination) : null;
    }

    protected void useDestination(Object pDestination) {
        this.fDestination = pDestination;
    }
}

