/*
 * Decompiled with CFR 0.152.
 */
package org.myire.quill.jacoco;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.reporting.Report;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.gradle.testing.jacoco.tasks.JacocoReportsContainer;
import org.myire.quill.common.Projects;
import org.myire.quill.report.Reports;

public class JacocoAdditionsPlugin
implements Plugin<Project> {
    private static final String DEFAULT_TOOL_VERSION = "0.8.7";
    private static final String JACOCO_TEST_REPORT_TASK_NAME = "jacocoTestReport";

    public void apply(Project pProject) {
        pProject.getPlugins().apply(JavaPlugin.class);
        pProject.getPlugins().apply(JacocoPlugin.class);
        this.configureExtension(pProject);
        this.configureReportTask(pProject);
    }

    private void configureExtension(Project pProject) {
        JacocoPluginExtension aExtension = Projects.getExtension(pProject, "jacoco", JacocoPluginExtension.class);
        if (aExtension != null) {
            aExtension.setToolVersion(DEFAULT_TOOL_VERSION);
        }
    }

    private void configureReportTask(Project pProject) {
        JacocoReport aTask = Projects.getTask(pProject, JACOCO_TEST_REPORT_TASK_NAME, JacocoReport.class);
        if (aTask != null) {
            JacocoReportsContainer aReports = aTask.getReports();
            Reports.setRequired((Report)aReports.getXml(), true);
            Reports.setRequired((Report)aReports.getHtml(), true);
            Reports.setRequired((Report)aReports.getCsv(), false);
            Task aBuildTask = Projects.getTask(pProject, "build", Task.class);
            if (aBuildTask != null) {
                aBuildTask.dependsOn(new Object[]{aTask});
            }
        }
    }
}

